% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mean.R
\docType{methods}
\name{mean}
\alias{mean}
\alias{mean,IntervalList-method}
\title{Calculate the sample Aumann mean of \eqn{n} interval-valued data}
\usage{
\S4method{mean}{IntervalList}(x)
}
\arguments{
\item{x}{a list of interval-valued data.}
}
\value{
Returns the calculated sample Aumann mean of \eqn{n} interval-valued data, i.e., other interval-valued data.
}
\description{
This function calculates the sample Aumann mean of \eqn{n} interval-valued data.
}
\examples{
mean(IntervalList(c(1, 3), c(2, 5)))
}
\references{
Aumann, R.J. (1965). Integrals of set-valued functions. Journal of Mathematical Analysis
and Applications, 12(1):1-12.
}
\seealso{
Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()},
\code{\link{sum}()},
\code{\link{var}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalList-method}
