% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\name{lambda}
\alias{lambda}
\title{Decay constants}
\usage{
lambda(nuclide, x = NULL, e = NULL)
}
\arguments{
\item{nuclide}{the nuclide name}

\item{x}{new value for the decay constant}

\item{e}{new value for the decay constant uncertainty}
}
\value{
if \code{x==e==NULL}, returns a two-item vector containing
    the decay constant [in Ma-1] and its standard error,
    respectively.
}
\description{
Gets or sets the decay constants of radioactive istopes
}
\examples{
print(lambda('U238'))
# use the decay constant of Kovarik and Adams (1932)
lambda('U238',0.0001537,0.0000068)
print(lambda('U238'))
}

