/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.JGRStyledDocument;

public class ConsoleOutput
extends JTextPane {
    private boolean lastLineWasEmpty = false;
    private String prompt = null;
    private String continueS = null;

    public ConsoleOutput() {
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this);
        this.setDocument(new JGRStyledDocument());
    }

    public void startExport() {
        new ExportOutput(this);
    }

    private void exportCommands(File file) {
        this.saveToFile(file, this.getCommands());
    }

    public void copyCommands() {
        try {
            int n = this.getLineOfOffset(this.getSelectionStart());
            int n2 = this.getLineOfOffset(this.getSelectionEnd());
            if (n >= n2 || n == -1 || n2 == -1) {
                return;
            }
            StringSelection stringSelection = new StringSelection(this.getCommands(n, n2).toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
        catch (Exception exception) {
            return;
        }
    }

    private StringBuffer getCommands() {
        return this.getCommands(0, this.getLineCount());
    }

    private StringBuffer getCommands(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var4_4 = null;
        for (int i = n; i <= n2; ++i) {
            try {
                if (!this.isCorrectLine(i) || !this.isCommandLine(i)) continue;
                String string = this.trimFront(this.getLine(i).replaceFirst(this.prompt, ""));
                if (i < this.getLineCount() && this.isCorrectLine(i + 1) && !string.startsWith("#")) {
                    stringBuffer.append(string);
                    continue;
                }
                if (i < this.getLineCount() && !this.isCorrectLine(i + 1) && string.startsWith(this.continueS)) {
                    stringBuffer.append(string);
                    continue;
                }
                if (i != this.getLineCount() || string.startsWith("#")) continue;
                stringBuffer.append(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer;
    }

    private void exportOutput(File file) {
        this.saveToFile(file, this.getOutput());
    }

    public void copyOutput() {
        try {
            int n = this.getLineOfOffset(this.getSelectionStart());
            int n2 = this.getLineOfOffset(this.getSelectionEnd());
            if (n >= n2 || n == -1 || n2 == -1) {
                return;
            }
            StringSelection stringSelection = new StringSelection(this.getOutput(n, n2).toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
        catch (Exception exception) {
            return;
        }
    }

    private StringBuffer getOutput() {
        return this.getOutput(0, this.getLineCount());
    }

    private StringBuffer getOutput(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            try {
                if (!this.isCorrectLine(i)) continue;
                stringBuffer.append(this.getLine(i));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuffer;
    }

    private void exportResult(File file) {
        this.saveToFile(file, this.getResult());
    }

    public void copyResults() {
        try {
            int n = this.getLineOfOffset(this.getSelectionStart());
            int n2 = this.getLineOfOffset(this.getSelectionEnd());
            if (n >= n2 || n == -1 || n2 == -1) {
                return;
            }
            StringSelection stringSelection = new StringSelection(this.getResult(n, n2).toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
        catch (Exception exception) {
            return;
        }
    }

    private StringBuffer getResult() {
        return this.getResult(0, this.getLineCount());
    }

    private StringBuffer getResult(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            try {
                if (!this.isCorrectLine(i)) continue;
                if (this.isResultLine(i)) {
                    String string = this.getLine(i);
                    if (string.trim().startsWith("Error")) continue;
                    stringBuffer.append(this.getLine(i));
                    this.lastLineWasEmpty = false;
                    continue;
                }
                if (!this.lastLineWasEmpty) {
                    stringBuffer.append("\n");
                }
                this.lastLineWasEmpty = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer;
    }

    private boolean isCommandLine(int n) throws BadLocationException {
        String string;
        if (this.prompt == null) {
            this.prompt = RController.getRPrompt();
        }
        if (this.continueS == null) {
            this.continueS = RController.getRContinue();
        }
        if ((string = this.getLine(n)).equals(this.prompt.trim())) {
            return false;
        }
        return string.trim().startsWith(this.prompt.trim()) || string.trim().startsWith(this.continueS.trim());
    }

    private boolean isResultLine(int n) throws BadLocationException {
        String string;
        if (this.prompt == null) {
            this.prompt = RController.getRPrompt();
        }
        if (this.continueS == null) {
            this.continueS = RController.getRContinue();
        }
        return !(string = this.getLine(n)).trim().startsWith(this.prompt.trim()) && !string.trim().startsWith(this.continueS.trim());
    }

    private boolean isCorrectLine(int n) {
        if (this.prompt == null) {
            this.prompt = RController.getRPrompt();
        }
        if (this.continueS == null) {
            this.continueS = RController.getRContinue();
        }
        return this.getLine(n).trim().length() != 0 && !this.getLine(n).trim().equals(this.prompt.trim()) && !this.getLine(n).trim().startsWith("Error");
    }

    private String trimFront(String string) {
        string = string.replaceFirst("\\s*", "");
        return string;
    }

    private String getLine(int n) {
        String string = null;
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n);
            string = this.getText(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File file, StringBuffer stringBuffer) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(JGR.MAINRCONSOLE, "Permisson denied", "File Error", 0);
        }
    }

    public String getText() {
        try {
            Document document = this.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getText(int n, int n2) {
        try {
            Document document = this.getDocument();
            return document.getText(0, document.getLength()).substring(n, n + n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void append(String string, AttributeSet attributeSet) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                document.insertString(document.getLength(), string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public int getLineCount() {
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementCount();
    }

    public int getLineStartOffset(int n) throws BadLocationException {
        int n2 = this.getLineCount();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= n2) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        return element2.getStartOffset();
    }

    public int getLineEndOffset(int n) throws BadLocationException {
        int n2 = this.getLineCount();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= n2) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n3 = element2.getEndOffset();
        return n == n2 - 1 ? n3 - 1 : n3;
    }

    public int getLineOfOffset(int n) throws BadLocationException {
        Document document = this.getDocument();
        if (n < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (n > document.getLength()) {
            throw new BadLocationException("Can't translate offset to line", document.getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementIndex(n);
    }

    public void removeAllFrom(int n) throws BadLocationException {
        this.getDocument().remove(n, this.getDocument().getLength() - n);
    }

    public void setFont(Font font) {
        super.setFont(font);
        try {
            ((StyledDocument)this.getDocument()).setCharacterAttributes(0, this.getText().length(), JGRPrefs.SIZE, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ExportOutput
    extends JFileChooser
    implements ActionListener {
        private ConsoleOutput out;
        private JRadioButton wholeOutput;
        private JRadioButton cmdsOutput;
        private JRadioButton resultOutput;
        private JButton ok;
        private JButton cancel;

        public ExportOutput(ConsoleOutput consoleOutput2) {
            super(JGRPrefs.workingDirectory);
            this.wholeOutput = new JRadioButton("Complete Output", true);
            this.cmdsOutput = new JRadioButton("Commands", false);
            this.resultOutput = new JRadioButton("Results", false);
            this.ok = new JButton("Save");
            this.cancel = new JButton("Cancel");
            this.out = consoleOutput2;
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.wholeOutput);
            buttonGroup.add(this.cmdsOutput);
            buttonGroup.add(this.resultOutput);
            this.addActionListener(this);
            if (System.getProperty("os.name").startsWith("Window")) {
                JPanel jPanel = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(2);
                JPanel jPanel2 = new JPanel(new FlowLayout(0));
                jPanel2.add(new JLabel("Options: "));
                jPanel2.add(this.wholeOutput);
                jPanel2.add(this.cmdsOutput);
                jPanel2.add(this.resultOutput);
                jPanel.add(jPanel2);
                JPanel jPanel3 = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(0);
                jPanel3.add(new JPanel());
            } else {
                JPanel jPanel = (JPanel)this.getComponent(this.getComponentCount() - 1);
                JPanel jPanel4 = new JPanel(new FlowLayout(0));
                jPanel4.add(new JLabel("Options: "));
                jPanel4.add(this.wholeOutput);
                jPanel4.add(this.cmdsOutput);
                jPanel4.add(this.resultOutput);
                jPanel.add((Component)jPanel4, jPanel.getComponentCount() - 1);
            }
            this.showSaveDialog(consoleOutput2);
        }

        public void export(File file) {
            if (this.wholeOutput.isSelected()) {
                this.out.exportOutput(file);
            } else if (this.cmdsOutput.isSelected()) {
                this.out.exportCommands(file);
            } else if (this.resultOutput.isSelected()) {
                this.out.exportResult(file);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "ApproveSelection") {
                this.export(this.getSelectedFile());
            }
        }
    }
}

