/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRObjectManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.robjects.RObject;

public class FunctionList
extends JList
implements KeyListener,
MouseListener {
    private JGRObjectManager objmgr;
    private DefaultListModel fmodel = new DefaultListModel();

    public FunctionList(JGRObjectManager jGRObjectManager, Collection collection) {
        this.setModel(this.fmodel);
        this.fmodel.removeAllElements();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.fmodel.addElement(iterator.next());
        }
        this.objmgr = jGRObjectManager;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void refresh(Collection collection) {
        this.fmodel.removeAllElements();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.fmodel.addElement(iterator.next());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            RObject rObject = null;
            try {
                rObject = (RObject)this.getSelectedValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rObject != null) {
                RController.newFunction(rObject);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
            Object[] objectArray = this.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                RObject rObject = null;
                try {
                    rObject = (RObject)objectArray[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (rObject == null) continue;
                JGR.R.eval("rm(" + rObject.getRName() + ")");
                this.fmodel.removeElement(objectArray[i]);
            }
        }
    }
}

