/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.browser.BrowserController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.BrowserNodeFactory;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;

public class DefaultBrowserNode
implements BrowserNode,
BrowserNodeFactory {
    protected String cls;
    protected String rName;
    protected BrowserNode parent;
    protected boolean isList = false;
    protected volatile ArrayList children = new ArrayList();
    protected boolean expanded;
    protected ImageIcon icon;
    TreeCellRenderer renderer = new DefaultBrowserCellRenderer();

    public DefaultBrowserNode() {
    }

    public DefaultBrowserNode(BrowserNode browserNode, String string, String string2) {
        this.parent = browserNode;
        this.rName = string;
        this.cls = string2;
        this.icon = this.findIcon();
    }

    protected ImageIcon findIcon() {
        URL uRL = this.getClass().getResource("/icons/tree_" + this.cls + ".png");
        BufferedImage bufferedImage = null;
        ImageIcon imageIcon = null;
        try {
            bufferedImage = ImageIO.read(uRL);
            imageIcon = new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            uRL = this.getClass().getResource("/icons/tree_default.png");
            bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(uRL);
                imageIcon = new ImageIcon(bufferedImage);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        return imageIcon;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return this.isList;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (treeNode != this.children.get(i)) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return !this.isList;
    }

    public String getRName() {
        return this.rName;
    }

    public String getExecuteableRObjectName() {
        if (this.parent == null) {
            return this.rName;
        }
        return this.parent.getChildExecuteableRObjectName(this);
    }

    public String getChildExecuteableRObjectName(BrowserNode browserNode) {
        return this.getExecuteableRObjectName() + "[[" + (this.getIndex(browserNode) + 1) + "]]";
    }

    public BrowserNode generate(BrowserNode browserNode, String string, String string2) {
        return new DefaultBrowserNode(browserNode, string, string2);
    }

    public TreeCellRenderer getRenderer() {
        return this.renderer;
    }

    public void addChild(BrowserNode browserNode) {
        this.children.add(browserNode);
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this.children.add(n, mutableTreeNode);
    }

    public void remove(int n) {
        this.children.remove(n);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        this.children.remove(this.getIndex(mutableTreeNode));
    }

    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (BrowserNode)mutableTreeNode;
    }

    public void setUserObject(Object object) {
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public synchronized void update(DefaultTreeModel stringArray) {
        String string = this.parent.getChildExecuteableRObjectName(this);
        try {
            REXP rEXP = JGR.idleEval("is.list(" + string + ")");
            if (rEXP == null) {
                return;
            }
            this.isList = ((REXPLogical)rEXP).isTRUE()[0];
            if (!this.expanded) {
                this.children.clear();
                return;
            }
            if (this.isList) {
                int n;
                boolean[] blArray;
                String[] stringArray2;
                String[] stringArray3;
                Object object;
                rEXP = JGR.idleEval("length(" + string + ")>0");
                if (rEXP == null) {
                    return;
                }
                boolean bl = ((REXPLogical)rEXP).isTRUE()[0];
                if (!bl && this.children.size() > 0) {
                    object = this.children.toArray();
                    stringArray3 = stringArray;
                    SwingUtilities.invokeAndWait(new Runnable((Object[])object, (DefaultTreeModel)stringArray3){
                        private final /* synthetic */ Object[] val$tmp;
                        private final /* synthetic */ DefaultTreeModel val$m;
                        {
                            this.val$tmp = objectArray;
                            this.val$m = defaultTreeModel;
                        }

                        public void run() {
                            for (int i = 0; i < this.val$tmp.length; ++i) {
                                this.val$m.removeNodeFromParent((MutableTreeNode)this.val$tmp[i]);
                            }
                        }
                    });
                }
                if (!bl) {
                    return;
                }
                object = JGR.idleEval("names(" + string + ")");
                if (object == null) {
                    return;
                }
                rEXP = JGR.idleEval("sapply(" + string + ",function(a)class(a)[1])");
                if (rEXP == null) {
                    return;
                }
                stringArray3 = rEXP.asStrings();
                if (object == null || ((REXP)object).isNull()) {
                    stringArray2 = new String[stringArray3.length];
                    blArray = new boolean[stringArray3.length];
                    for (n = 0; n < stringArray3.length; ++n) {
                        stringArray2[n] = null;
                        blArray[n] = true;
                    }
                } else {
                    stringArray2 = ((REXP)object).asStrings();
                    blArray = ((REXP)object).isNA();
                }
                if (stringArray2.length < this.children.size()) {
                    String[] stringArray4 = stringArray;
                    final String[] stringArray5 = stringArray2;
                    SwingUtilities.invokeAndWait(new Runnable((DefaultTreeModel)stringArray4){
                        private final /* synthetic */ DefaultTreeModel val$m;
                        {
                            this.val$m = defaultTreeModel;
                        }

                        public void run() {
                            for (int i = DefaultBrowserNode.this.children.size() - 1; i >= stringArray5.length; --i) {
                                this.val$m.removeNodeFromParent((MutableTreeNode)DefaultBrowserNode.this.children.get(i));
                            }
                        }
                    });
                }
                n = Math.min(stringArray2.length, BrowserController.MAX_CHILDREN);
                for (int i = 0; i < n; ++i) {
                    BrowserNode browserNode = BrowserController.createNode(this, blArray[i] ? null : stringArray2[i], stringArray3[i]);
                    if (this.children.size() > i && this.children.get(i).equals(browserNode)) {
                        ((BrowserNode)this.children.get(i)).update((DefaultTreeModel)stringArray);
                        continue;
                    }
                    final Object[] objectArray = this.children.toArray();
                    final int n2 = i;
                    String[] stringArray6 = stringArray;
                    int n3 = this.children.size();
                    SwingUtilities.invokeAndWait(new Runnable((DefaultTreeModel)stringArray6, browserNode, n3){
                        private final /* synthetic */ DefaultTreeModel val$m;
                        private final /* synthetic */ BrowserNode val$node;
                        private final /* synthetic */ int val$nChildren;
                        {
                            this.val$m = defaultTreeModel;
                            this.val$node = browserNode;
                            this.val$nChildren = n22;
                        }

                        public void run() {
                            if (objectArray.length > n2) {
                                for (int i = n2; i < objectArray.length; ++i) {
                                    this.val$m.removeNodeFromParent((MutableTreeNode)objectArray[i]);
                                }
                            }
                            this.val$m.insertNodeInto(this.val$node, DefaultBrowserNode.this, this.val$nChildren);
                        }
                    });
                    browserNode.update((DefaultTreeModel)stringArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultBrowserNode)) {
            return false;
        }
        DefaultBrowserNode defaultBrowserNode = (DefaultBrowserNode)object;
        return (this.cls == null ? defaultBrowserNode.cls == null : this.cls.equals(defaultBrowserNode.cls)) && (this.rName == null ? defaultBrowserNode.rName == null : this.rName.equals(defaultBrowserNode.rName));
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        PopupListener popupListener = new PopupListener();
        JMenuItem jMenuItem = new JMenuItem("Edit");
        jMenuItem.addActionListener(popupListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(popupListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Summary");
        jMenuItem.addActionListener(popupListener);
        jMenuItem = new JMenuItem("Plot");
        jMenuItem.addActionListener(popupListener);
        jMenuItem = new JMenuItem("Remove");
        jMenuItem.addActionListener(popupListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void editObject() {
        try {
            REXP rEXP = JGR.timedEval("suppressWarnings(try(paste(capture.output(dput(" + this.getExecuteableRObjectName() + ")),collapse=\"\n\"),silent=TRUE))");
            if (rEXP != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getExecuteableRObjectName() + "<-");
                stringBuffer.append(rEXP.asString());
                Editor editor = new Editor();
                editor.setText(stringBuffer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printObject() {
        JGR.MAINRCONSOLE.execute("print(" + this.getExecuteableRObjectName() + ")");
    }

    public void summaryObject() {
        JGR.MAINRCONSOLE.execute("summary(" + this.getExecuteableRObjectName() + ")");
    }

    public void plotObject() {
        JGR.MAINRCONSOLE.execute("plot(" + this.getExecuteableRObjectName() + ")");
    }

    public void removeChildObjectFromR(BrowserNode browserNode) {
        JGR.MAINRCONSOLE.execute(browserNode.getExecuteableRObjectName() + " <- NULL");
    }

    class PopupListener
    implements ActionListener {
        PopupListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final String string = actionEvent.getActionCommand();
            new Thread(new Runnable(){

                public void run() {
                    PopupListener.this.runCmd(string);
                }
            }).start();
        }

        public void runCmd(String string) {
            if (string.equals("Edit")) {
                DefaultBrowserNode.this.editObject();
            } else if (string.equals("Print")) {
                DefaultBrowserNode.this.printObject();
            } else if (string.equals("Summary")) {
                DefaultBrowserNode.this.summaryObject();
            } else if (string.equals("Plot")) {
                DefaultBrowserNode.this.plotObject();
            } else if (string.equals("Remove")) {
                DefaultBrowserNode.this.parent.removeChildObjectFromR(DefaultBrowserNode.this);
            }
        }
    }

    class DefaultBrowserCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (DefaultBrowserNode.this.rName != null) {
                this.setText(DefaultBrowserNode.this.rName);
            } else {
                this.setText("" + (DefaultBrowserNode.this.parent.getIndex(DefaultBrowserNode.this) + 1));
            }
            this.setIcon(DefaultBrowserNode.this.icon);
            this.setVerticalAlignment(0);
            this.setVerticalTextPosition(0);
            this.setSize(new Dimension(26, jTree.getWidth()));
            this.setToolTipText(DefaultBrowserNode.this.cls);
            return this;
        }
    }
}

