/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import jedit.syntax.FindReplaceDialog;
import jedit.syntax.JEditTextArea;
import jedit.syntax.RTokenMarker;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.editor.EditToolbar;
import org.rosuda.JGR.editor.RInputHandler;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.DocumentRenderer;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPString;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.util.RecentList;

public class Editor
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = -2281511772856410211L;
    public static RecentList recentOpen;
    public JMenu recentMenu;
    JEditTextArea textArea = new JEditTextArea();
    JLabel modifiedStatus = new JLabel("   ");
    CaretListenerLabel cLabel = new CaretListenerLabel();
    private boolean modified = false;
    private String fileName;

    public Editor() {
        this((String)null);
    }

    public Editor(String file) {
        this(file, true);
    }

    public Editor(String file, boolean visible) {
        super("Editor", false, 150);
        this.setLayout(new BorderLayout());
        String[] Menu = new String[]{"+", "File", "@NNew", "new", "@OOpen", "open", "#Open Recent", "", "@SSave", "save", "!SSave as", "saveas", "-", "@PPrint", "print", "-", "@QQuit", "quit", "+", "Edit", "@ZUndo", "undo", "!ZRedo", "redo", "-", "@XCut", "cut", "@CCopy", "copy", "@VPaste", "paste", "-", "@/Comment out", "commentcode", "@;Uncomment", "uncommentcode", "-", "!LShift Left", "shiftleft", "!RShift Right", "shiftright", "-", "Format Selection", "Format Selection", "-", "@RRun Selection", "runselection", "Run all", "runall", "-", "@FFind", "find", "@GFind next", "findnext", "+", "Tools", "!IIncrease Font Size", "fontBigger", "!DDecrease Font Size", "fontSmaller", "~Window", "+", "Help", "R Help", "help", "~Preferences", "~About", "0"};
        EzMenuSwing.getEzMenu(this, this, Menu);
        JMenu rm = this.recentMenu = (JMenu)EzMenuSwing.getItem(this, "Open Recent");
        if (rm != null) {
            int i;
            rm.removeAll();
            if (recentOpen == null) {
                recentOpen = new RecentList("JGR", "RecentOpenFiles", 8);
            }
            String[] shortNames = recentOpen.getShortEntries();
            String[] longNames = recentOpen.getAllEntries();
            for (i = 0; i < shortNames.length; ++i) {
                JMenuItem mi = new JMenuItem(shortNames[i]);
                mi.setActionCommand("recent:" + longNames[i]);
                mi.addActionListener(this);
                rm.add(mi);
            }
            if (i > 0) {
                rm.addSeparator();
            }
            JMenuItem ca = new JMenuItem("Clear list");
            ca.setActionCommand("recent-clear");
            ca.addActionListener(this);
            rm.add(ca);
            if (i == 0) {
                ca.setEnabled(false);
            }
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Editor.this.exit();
            }
        });
        this.textArea.getDocument().setTokenMarker(new RTokenMarker());
        RInputHandler rih = new RInputHandler();
        rih.addKeyBindings();
        this.textArea.setInputHandler(rih);
        this.textArea.addCaretListener(this.cLabel);
        int mw = Toolkit.getDefaultToolkit().getScreenSize().width - 100;
        int mh = Toolkit.getDefaultToolkit().getScreenSize().height - 50;
        this.textArea.setPreferredSize(new Dimension(Math.min(600, mw), Math.min(800, mh)));
        JPanel status = new JPanel(new FlowLayout(2));
        status.add(this.modifiedStatus);
        status.add(this.cLabel);
        this.add((Component)this.textArea, "Center");
        this.add((Component)status, "South");
        this.pack();
        this.textArea.requestFocus();
        new EditToolbar(this, this);
        if (file != null) {
            this.fileName = file;
            this.openFile(file);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                super.componentResized(evt);
                Editor.this.setTitle(Editor.this.fileName);
            }
        });
        if (visible) {
            this.setVisible(true);
        }
        this.initPlacement();
        this.toFront();
        this.requestFocus();
        this.textArea.requestFocus();
    }

    public static void main(String[] args) {
        Editor e = new Editor();
        e.setVisible(true);
    }

    public void dispose() {
        this.exit();
    }

    public boolean exit() {
        if (this.modified) {
            int i = JOptionPane.showConfirmDialog(this, "Save File?", "Exit", 1, 3);
            if (i == 1) {
                super.dispose();
                return true;
            }
            if (i == 0 && this.saveFile()) {
                super.dispose();
                return true;
            }
            return false;
        }
        super.dispose();
        return true;
    }

    private boolean saveFile() {
        if (this.fileName == null || this.fileName.equals("")) {
            return this.saveFileAs();
        }
        this.setWorking(true);
        this.textArea.saveFile(this.fileName);
        this.setWorking(false);
        this.setTitle(this.fileName == null ? "Editor" : this.fileName);
        this.modified = false;
        this.setModified(false);
        return true;
    }

    public void setText(StringBuffer sb) {
        this.textArea.setText(sb.toString());
    }

    public void open() {
        this.openFile();
    }

    private void openFile() {
        this.openFile(null);
    }

    private void openFile(String file) {
        String newFile = file;
        if (file == null) {
            FileSelector fopen = new FileSelector(this, "Open...", 0, JGRPrefs.workingDirectory);
            fopen.setVisible(true);
            if (fopen.getFile() != null) {
                JGRPrefs.workingDirectory = fopen.getDirectory();
                newFile = JGRPrefs.workingDirectory + fopen.getFile();
            }
        } else {
            newFile = file;
        }
        if (newFile != null && newFile.trim().length() > 0) {
            this.setWorking(true);
            String tempfileName = newFile;
            if (recentOpen == null) {
                recentOpen = new RecentList("JGR", "RecentOpenFiles", 8);
            }
            recentOpen.addEntry(tempfileName);
            JMenu rm = this.recentMenu = (JMenu)EzMenuSwing.getItem(this, "Open Recent");
            if (rm != null) {
                int i;
                rm.removeAll();
                String[] shortNames = recentOpen.getShortEntries();
                String[] longNames = recentOpen.getAllEntries();
                for (i = 0; i < shortNames.length; ++i) {
                    JMenuItem mi = new JMenuItem(shortNames[i]);
                    mi.setActionCommand("recent:" + longNames[i]);
                    mi.addActionListener(this);
                    rm.add(mi);
                }
                if (i > 0) {
                    rm.addSeparator();
                }
                JMenuItem ca = new JMenuItem("Clear list");
                ca.setActionCommand("recent-clear");
                ca.addActionListener(this);
                rm.add(ca);
                if (i == 0) {
                    ca.setEnabled(false);
                }
            }
            if (this.modified) {
                Editor newEditor = new Editor(null, false);
                newEditor.textArea.setText("");
                newEditor.textArea.loadFile(newFile);
                newEditor.fileName = tempfileName;
                newEditor.modified = false;
                newEditor.setModified(false);
                newEditor.setVisible(true);
                newEditor.setTitle(newFile);
            } else {
                this.setWorking(true);
                this.textArea.setText("");
                this.textArea.loadFile(tempfileName);
                this.setVisible(true);
                this.fileName = tempfileName;
                this.setTitle(newFile);
            }
            this.setWorking(false);
        }
    }

    private void newEditor() {
        Editor e = new Editor();
        e.setVisible(true);
    }

    public void setTitle(String title) {
        int length;
        int cc = 1;
        if (System.getProperty("os.name").startsWith("Win")) {
            super.setTitle(title == null ? "Editor" : title);
            return;
        }
        try {
            length = this.getFontMetrics(this.getFont()).stringWidth(title);
        }
        catch (Exception e) {
            super.setTitle(title == null ? "Editor" : title);
            return;
        }
        boolean next = true;
        while (length > this.getWidth() - 100 && next) {
            int z;
            StringTokenizer st = new StringTokenizer(title, File.separator);
            int i = st.countTokens();
            title = !JGRPrefs.isMac ? st.nextElement() + "" + File.separator : File.separator;
            if (cc > i) {
                for (z = 1; z < i && st.hasMoreTokens(); ++z) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    title = st.nextToken();
                }
                next = false;
            } else {
                for (z = 1; z <= i && st.hasMoreTokens(); ++z) {
                    if (z <= i / 2 - (cc - cc / 2) || z > i / 2 + cc / 2) {
                        title = title + st.nextToken() + "" + (st.hasMoreTokens() ? File.separator : "");
                        continue;
                    }
                    title = title + "..." + File.separator;
                    st.nextToken();
                }
                next = true;
            }
            length = this.getFontMetrics(this.getFont()).stringWidth(title);
            ++cc;
        }
        super.setTitle(title);
    }

    private boolean saveFileAs() {
        FileSelector fsave = new FileSelector(this, "Save as...", 1, JGRPrefs.workingDirectory);
        fsave.setVisible(true);
        if (fsave.getFile() != null) {
            JGRPrefs.workingDirectory = fsave.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fsave.getFile();
            return this.saveFile();
        }
        return false;
    }

    private void setModified(boolean mod) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Editor.this.modifiedStatus.setText(Editor.this.modified ? "Modified" : "");
            }
        });
    }

    public void print() {
        DocumentRenderer docrender = new DocumentRenderer();
        docrender.print(this.textArea.getDocument());
    }

    public void actionPerformed(ActionEvent e) {
        String s;
        if ("about".equalsIgnoreCase(e.getActionCommand())) {
            new AboutDialog(this);
        }
        if ("new".equalsIgnoreCase(e.getActionCommand())) {
            this.newEditor();
        }
        if ("open".equalsIgnoreCase(e.getActionCommand())) {
            this.openFile();
        }
        if ("save".equalsIgnoreCase(e.getActionCommand())) {
            this.saveFile();
        }
        if ("saveas".equalsIgnoreCase(e.getActionCommand())) {
            this.saveFileAs();
        }
        if ("copy".equalsIgnoreCase(e.getActionCommand())) {
            this.textArea.copy();
        }
        if ("cut".equalsIgnoreCase(e.getActionCommand())) {
            this.textArea.cut();
        }
        if ("paste".equalsIgnoreCase(e.getActionCommand())) {
            this.textArea.paste();
        }
        if ("undo".equalsIgnoreCase(e.getActionCommand())) {
            this.textArea.undo();
        }
        if ("redo".equalsIgnoreCase(e.getActionCommand())) {
            this.textArea.redo();
        }
        if ("find".equalsIgnoreCase(e.getActionCommand())) {
            FindReplaceDialog.findExt(this, this.textArea);
        }
        if ("findnext".equalsIgnoreCase(e.getActionCommand())) {
            FindReplaceDialog.findNextExt(this, this.textArea);
        }
        if ("fontBigger".equalsIgnoreCase(e.getActionCommand())) {
            FontTracker.current.setFontBigger();
        }
        if ("fontSmaller".equalsIgnoreCase(e.getActionCommand())) {
            FontTracker.current.setFontSmaller();
        }
        if (e.getActionCommand() == "commentcode") {
            if (this.textArea.getSelectedText() != null && this.textArea.getSelectedText().trim().length() > 0) {
                try {
                    this.textArea.commentSelection(true);
                }
                catch (BadLocationException e1) {}
            }
        } else if (e.getActionCommand() == "uncommentcode") {
            if (this.textArea.getSelectedText() != null && this.textArea.getSelectedText().trim().length() > 0) {
                try {
                    this.textArea.commentSelection(false);
                }
                catch (BadLocationException e1) {}
            }
        } else if (e.getActionCommand() == "Format Selection" && this.textArea.getSelectedText() != null && this.textArea.getSelectedText().trim().length() > 0) {
            try {
                String txt = this.textArea.getSelectedText();
                JGR.getREngine().assign("..text_code..", txt);
                REXP sexp = JGR.timedEval("reformat.code(..text_code..)");
                if (sexp != null && sexp instanceof REXPString) {
                    String newText = sexp.asString();
                    this.textArea.setSelectedText(newText);
                }
                JGR.timedEval("rm('..text_code..')");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (e.getActionCommand().startsWith("recent:")) {
            if (this.modified) {
                new Editor(e.getActionCommand().replaceFirst("recent:", ""));
            } else {
                this.fileName = e.getActionCommand().replaceFirst("recent:", "");
                this.openFile(this.fileName);
            }
        } else if (e.getActionCommand() == "preferences") {
            PrefDialog inst = PrefDialog.showPreferences(this);
            inst.setLocationRelativeTo(null);
            inst.setVisible(true);
        } else if (e.getActionCommand() == "print") {
            this.print();
        } else if (e.getActionCommand() == "recent-clear" && recentOpen != null && this.recentMenu != null) {
            this.recentMenu.removeAll();
            this.recentMenu.addSeparator();
            JMenuItem ca = new JMenuItem("Clear list");
            ca.setActionCommand("recent-clear");
            ca.addActionListener(this);
            ca.setEnabled(false);
            this.recentMenu.add(ca);
            recentOpen.reset();
        }
        if (e.getActionCommand() == "help") {
            JGR.MAINRCONSOLE.execute("help.start()", false);
        }
        if (e.getActionCommand() == "shiftleft") {
            try {
                this.textArea.shiftSelection(-1);
            }
            catch (BadLocationException e1) {}
        } else if (e.getActionCommand() == "shiftright") {
            try {
                this.textArea.shiftSelection(1);
            }
            catch (BadLocationException e2) {
                // empty catch block
            }
        }
        if (e.getActionCommand() == "runall") {
            try {
                s = this.textArea.getText();
                if (s.length() > 0) {
                    JGR.MAINRCONSOLE.execute(s.trim(), true);
                }
            }
            catch (Exception ex) {}
        } else if (e.getActionCommand() == "runselection") {
            try {
                s = this.textArea.getSelectedText();
                if (s == null) {
                    s = "";
                }
                if ((s = s.trim()).length() == 0) {
                    int line = this.textArea.getSelectionStartLine();
                    s = this.textArea.getLineText(line).trim();
                    int pos = this.textArea.getLineStartOffset(line + 1);
                    if (pos > 0) {
                        this.textArea.setCaretPosition(pos);
                    }
                }
                if (s.length() > 0) {
                    JGR.MAINRCONSOLE.execute(s.trim(), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ("quit".equalsIgnoreCase(e.getActionCommand())) {
            this.exit();
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        private static final long serialVersionUID = -4451331086216529945L;

        public void caretUpdate(CaretEvent e) {
            Editor.this.modified = true;
            Editor.this.setModified(Editor.this.modified);
            this.displayInfo(e);
        }

        protected void displayInfo(CaretEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        int currentpos = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getCaretPosition();
                        int lastnewline = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getText().lastIndexOf("\n", currentpos - 1);
                        int chars = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getText(0, lastnewline < 0 ? 0 : lastnewline).length();
                        int currentline = ((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getLineOfOffset(((CaretListenerLabel)CaretListenerLabel.this).Editor.this.textArea.getCaretPosition()) + 1;
                        CaretListenerLabel.this.setText(currentline + ":" + (currentline == 1 ? currentpos + 1 : (currentpos -= chars)) + "   ");
                    }
                    catch (Exception e) {
                        new ErrorMsg(e);
                    }
                }
            });
        }
    }
}

