% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimDataC}
\alias{SimDataC}
\title{Data simulation of continuous outcomes and competing risks}
\usage{
SimDataC(
  k_val,
  p1_val,
  p1a_val,
  p2_val,
  g_val,
  truebeta,
  truegamma,
  randeffect,
  yfn,
  cfn,
  mfn
)
}
\arguments{
\item{k_val}{The number of subjects in study.}

\item{p1_val}{The dimension of fixed effects in longitudinal measurements.}

\item{p1a_val}{The dimension of random effects in longitudinal measurements.}

\item{p2_val}{The dimension of fixed effects in competing risks failure time data.}

\item{g_val}{The number of type of failure in competing risks data.}

\item{truebeta}{True values for beta, the longitudinal coefficients.}

\item{truegamma}{True values for gamma, the survival coefficients.}

\item{randeffect}{True values for random effects in longitudinal  and competing risks parts,namely in the order of \eqn{\sigma},\eqn{\sigma_b},\eqn{\nu_2},\eqn{\sigma_u}.}

\item{yfn}{Filename of genereated Y matrix for longitudinal measurements in long format.}

\item{cfn}{Filename of genereated C matrix for competing risks failure time data.}

\item{mfn}{Filename of genereated M vector to indicate the number of longitudinal measurements per subject.}
}
\value{
Files with names yfn, cfn and mfn.
\tabular{ll}{
\code{censoring_rate} \tab Censoring rate of the survival data. \cr
\code{rate1} \tab Censoring rate of competing risk 1. \cr
\code{rate2} \tab Censoring rate of competing risk 2. \cr
\code{yfn} \tab Filename of genereated Y matrix for longitudinal measurements. \cr
\code{cfn} \tab Filename of genereated C matrix for competing risks failure time data. \cr
\code{mfn} \tab  Filename of genereated M vector to indicate the number of longitudinal measurements per subject. 
  }
}
\description{
Simulation of continuous longitudinal outcome and competing risks data
Currently, only the simulation in Elashoff et al(2008) is implemented.
}
\examples{
# A toy example testint data generations
require(JMcmprsk)
set.seed(123)
yfn=tempfile(pattern = "", fileext = ".txt")
cfn=tempfile(pattern = "", fileext = ".txt")
mfn=tempfile(pattern = "", fileext = ".txt")
k_val=30;p1_val=4;p1a_val=1; p2_val=2;g_val=2;
truebeta=c(10,-1,1.5,0.6);truegamma=c(0.8,-1,0.5,-1); randeffect=c(5,0.5,0.5,0.5);
#writing files
SimDataC(k_val, p1_val, p1a_val, p2_val, g_val,truebeta, 
         truegamma, randeffect, yfn,  cfn,  mfn)
\donttest{
jmc_0(p=4,yfn,cfn,mfn,point=6)
}
}
\references{
\itemize{
\item Elashoff, Robert M., Gang Li, and Ning Li. "A joint model for longitudinal measurements and survival data in the presence of multiple failure types." Biometrics 64.3 (2008): 762-771.
}
}
\seealso{
\code{\link{SimDataO}}
}
