% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lung}
\alias{lung}
\title{Scleroderma lung study data}
\format{
A balanced data set with respect to the times at which observations 
  recorded. The data consists of the following variables on each patient:
  
  \describe{
  
  \item{\code{ID}}{patient identifier.}
  \item{\code{FVC}}{forced vital capacity (\%) determined at 3-month intervals from the baseline.}
  
  \item{\code{time_RE}}{time at visit at 3-month intervals.}
  
  \item{\code{intercept}}{column of 1's for model setup.}
  
  \item{\code{time}}{time at visit at 3-month intervals. Same as \code{time_RE}.}
  
  \item{\code{FVC0}}{forced vital capacity (\%) at baseline.}
  
  \item{\code{FIB0}}{baseline lung fibrosis.}
  
  \item{\code{CYC}}{treatment allocation. Coded as \code{1} = oral cyclophosphamide; \code{0} = placebo.}
  
  \item{\code{FVC0.CYC}}{interaction term between \code{FVC0} and \code{CYC}.}
  
  \item{\code{FIB0.CYC}}{interaction term between \code{FIB0} and \code{CYC}.}
  
  \item{\code{time.CYC}}{interaction term between \code{time} and \code{CYC}.}
  
  \item{\code{time.CYC}}{interaction term between \code{time} and \code{CYC}.}
  
  \item{\code{surv}}{time to treatment failure or death.}
  
  \item{\code{failure_type}}{treatment failure/death indicator. Coded as \code{0} = censored; \code{1} = death; 
  \code{2} = treatment failure.}
  
  }
}
\usage{
data(lung)
}
\description{
The \code{lung} data frame has 715 rows and 13 columns.
}
\references{
Elashoff, Robert M., Gang Li, and Ning Li. "A joint model for longitudinal measurements and 
survival data in the presence of multiple failure types." Biometrics 64.3 (2008): 762-771.
}
\keyword{datasets}
