% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jnt_cont.R
\name{jnt_cont}
\alias{jnt_cont}
\title{Calculation and visualization of regions of non-significance to assess the
influence of continuous moderators}
\usage{
jnt_cont(
  X,
  Y,
  m,
  data,
  correlation = NULL,
  res = 100,
  xlab = X,
  ylab = Y,
  col.gradient = TRUE,
  sig_color = "lightblue",
  nonsig_color = "grey",
  max_col_grad = "red",
  min_col_grad = "blue",
  legend = TRUE
)
}
\arguments{
\item{X}{A character string defining the name of the covariate (e.g., size in
an allometry analysis). Must be the same as the name of the variable in the
dataset (see argument “data”).}

\item{Y}{A character string defining the name of the dependent variable. Must
be the same as the name of the variable in the dataset (see argument “data”).}

\item{m}{A character string defining the name of a continuous moderator.
Must be the same as the name of the variable in the dataset (see argument “data”).
The variable must be continuous.}

\item{data}{A dataframe containing the variables in the model.}

\item{correlation}{an optional \link{corStruct} object describing the within-group
correlation structure. See the documentation of \link{corClasses} for a description of
the available corStruct classes. If a grouping variable is to be used, it must be
specified in the form argument to the corStruct constructor. Defaults to NULL,
corresponding to uncorrelated errors.}

\item{res}{A numerical value that aids in the plotting of regions of (non)significance.
Default=100, higher numbers increase the number of fitted regression lines plotted (N=res-1).}

\item{xlab}{A title for the X axis. Defaults to the name of the predictor variable
in the data.}

\item{ylab}{A title for the Y axis. Defaults to the name of the dependent variable
in the data.}

\item{col.gradient}{A logical indicating whether the significant regression lines
should be plotted with a gradient of colors representing moderator values. Defaults to 'TRUE'.}

\item{sig_color}{If col.gradient = FALSE, a character string indicating the color of the significant
regression lines. Defaults to 'lightblue'.}

\item{nonsig_color}{If col.gradient = FALSE, a character string indicating the color of the non-significant
regression lines. Defaults to 'grey'.}

\item{max_col_grad}{If col.gradient = TRUE, a character string indicating the maximum color of
the gradient.}

\item{min_col_grad}{If col.gradient = TRUE, a character string indicating the minimum color of
the gradient.}

\item{legend}{A logical indicating whether a legend should appear on top of the plot. Defaults to 'TRUE'.}
}
\value{
List with six elements: (1) results from the linear model, (2) lower and
(3) upper limits of (non)significance in the moderator, (4) lower and (5) upper
data limit in the data, and (6) a graphical output.
}
\description{
Produces a plot showing how changes in the moderator affect the slope and
significance of the relationship between the dependent variable and the predictor.
}
\examples{
data(lizard_home_range)
jnt_cont(X='PHR95_overlap_z', Y='hrsize95', m='degree_z',
data=lizard_home_range, xlab = 'home range overlap 95',
ylab='home range size 95')
}
\references{
Toyama, K. S. (2023). JNplots: an R package to visualize outputs
from the Johnson-Neyman technique for categorical and continuous moderators,
including options for phylogenetic regressions. bioRxiv, 2023-05.
}
