% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styler.R
\name{APAStyler.SEMSummary}
\alias{APAStyler.SEMSummary}
\title{A generic function for pretty printing in (semi) APA Style}
\usage{
\method{APAStyler}{SEMSummary}(object, digits = 2, type = c("cov", "cor",
  "both"), stars = FALSE, file = ifelse(.Platform$OS.type == "windows",
  "clipboard", FALSE), sep = "\\t", ...)
}
\arguments{
\item{object}{\code{SEMSummary} object}

\item{digits}{The number of digits to round results to. Defaults to 2.}

\item{type}{A character vector giving what to print. Defaults to \sQuote{cov},
the covariances. Other options are \sQuote{cor} and \sQuote{both}.}

\item{stars}{A logical value whether to include significance values as
stars (*** p < .001, ** p < .01, * p < .05).}

\item{file}{An optional argument indicating whether the output should be written to a file.}

\item{sep}{Character what the separator for the table should be. Defaults to tabs.}

\item{...}{Additional argiuments passed on to \code{write.table}.}
}
\description{
A generic function for pretty printing in (semi) APA Style
}
\examples{
m <- SEMSummary(~., data = mtcars)
APAStyler(m, type = "cor", stars = FALSE, file = FALSE)
APAStyler(m, type = "cov", stars = FALSE, file = FALSE)
APAStyler(m, type = "both", stars = FALSE, file = FALSE)
APAStyler(m, type = "cor", stars = TRUE, file = FALSE)
APAStyler(m, type = "cov", stars = TRUE, file = FALSE)
APAStyler(m, type = "both", stars = TRUE, file = FALSE)
}

