% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_samples.R
\name{add_samples}
\alias{add_samples}
\title{Add samples to an object of class JointAI}
\usage{
add_samples(object, n.iter, add = TRUE, thin = NULL,
  monitor_params = NULL, progress.bar = "text", mess = TRUE)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{n.iter}{number of iterations to monitor}

\item{add}{logical; should the new MCMC samples be added to the existing
samples or replace them? If samples are added, \code{thin} and
\code{var.names} are ignored.}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{monitor_params}{named vector specifying which parameters should be
monitored}

\item{progress.bar}{character string specifying the type of progress bar.
Possible values are "text", "gui", and "none".
See \code{\link[rjags]{update}}.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}. Note: this applies only to messages
given directly by \strong{JointAI}.}
}
\description{
Allows to continue sampling from an existing object of class 'JointAI'.
When the original sample was created using parallel computation, the
separate 'jags' objects will be recompiled and sampling will again be
performed in parallel.
}
\examples{
# Example 1:
# Run an initial JointAI model:
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)

# Continue sampling:
mod_add <- add_samples(mod, n.iter = 200, add = TRUE)


# Example 2:
# Continue sampling, but additionally sample imputed values.
# Note: Setting different parameters to monitor than in the original model
# requires add = FALSE.
imps <- add_samples(mod, n.iter = 200, monitor_params = c("imps" = TRUE),
                    add = FALSE)

}
\seealso{
\code{\link{lm_imp}}, \code{\link{glm_imp}}, \code{\link{lme_imp}}, \code{\link{clm_imp}}
\code{\link{glme_imp}}, \code{\link{clmm_imp}}, \code{\link{survreg_imp}},
\code{\link{coxph_imp}}

The vignette \href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples how to specify the argument \code{monitor_params}.
}
