% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knoema.R
\name{Knoema}
\alias{Knoema}
\title{knoema package!
This package works with datasets from knoema.com}
\usage{
Knoema(dataset.id = NULL, selection = NULL, mnemonics = NULL,
  type = "ts", host = "", client.id = "", client.secret = "")
}
\arguments{
\item{dataset.id}{is Dataset's ID specified as a string}

\item{selection}{is list where all the dimensions of the dataset are listed and a selection from them}

\item{mnemonics}{are mnemonics values specified as a string separated by a semicolon}

\item{type}{is optional. By default equals "ts". Other supported variants are "xts","zoo","DataFrame","MetaDataFrame","DataTable","MetaDataTable"}

\item{host}{is optional. You can use "knoema.com" or other supported knoema's portals}

\item{client.id}{is client id from knoema application}

\item{client.secret}{is secret client code from knoema application
By default uses public user for knoema.com
By default the package allows you to work only with public datasets from the site knoema.com.
If you want to work with private datasets or from other hosts, you need to set optional parameters host, client.id and client.secret
You can get parameters client.id and client.secret after registering on the site knoema.com, in the section "My profile - Apps - create new" (or use existing applications)}
}
\value{
the list of timeseries in the selected format from the dataset
}
\description{
knoema package!
This package works with datasets from knoema.com
}
\examples{
Knoema("IMFWEO2017Oct", list(country = "512;914", subject = "NGDP_RPCH"),
           client.id = "FzOYqDg",
           client.secret="SPrvmY8eGRcGA")
Knoema("IMFWEO2017Oct", list(country = "512;914", subject = "NGDP_RPCH", frequency = "A"),
           type = "xts",
           client.id = "FzOYqDg",
           client.secret="SPrvmY8eGRcGA")
Knoema("IMFWEO2017Oct", list(country = "512;914", subject = "NGDP_RPCH", timerange = "2010-2015"),
           client.id = "FzOYqDg",
           client.secret="SPrvmY8eGRcGA")
Knoema(mnemonics="512NGDP_A_in_test_dataset",
           client.id = "FzOYqDg",
           client.secret="SPrvmY8eGRcGA")
}
