/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.share;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TagSet {
    public static final int TAG_SET_KAIST = 0;
    public static final int TAG_TYPE_ALL = 0;
    public static final int TAG_TYPE_VERBS = 1;
    public static final int TAG_TYPE_NOUNS = 2;
    public static final int TAG_TYPE_NPS = 3;
    public static final int TAG_TYPE_ADJS = 4;
    public static final int TAG_TYPE_NBNP = 5;
    public static final int TAG_TYPE_JOSA = 6;
    public static final int TAG_TYPE_YONGS = 7;
    public static final int TAG_TYPE_EOMIES = 8;
    public static final int TAG_TYPE_JP = 9;
    public static final int TAG_TYPE_COUNT = 10;
    public static final int PHONEME_TYPE_ALL = 0;
    public String title = "";
    public String version = "";
    public String copyright = "";
    public String author = "";
    public String date = "";
    public String editor = "";
    private ArrayList<String> tagList = new ArrayList();
    private ArrayList<String> irregularList = new ArrayList();
    private HashMap<String, int[]> tagSetMap = new HashMap();
    private int[][] tagTypeTable = new int[10][];
    public int[] indexTags = null;
    public int[] unkTags = null;
    public int iwgTag = 0;
    public int unkTag = 0;
    public int numTag = 0;
    public int IRR_TYPE_B;
    public int IRR_TYPE_S;
    public int IRR_TYPE_D;
    public int IRR_TYPE_H;
    public int IRR_TYPE_REU;
    public int IRR_TYPE_REO;

    public boolean checkPhonemeType(int phonemeType, int phoneme) {
        if (phonemeType == 0) {
            return true;
        }
        return phonemeType == phoneme;
    }

    public boolean checkTagType(int tagType, int tag) {
        if (tagType == 0) {
            return true;
        }
        int i = 0;
        while (i < this.tagTypeTable[tagType].length) {
            if (this.tagTypeTable[tagType][i] == tag) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        this.title = "";
        this.version = "";
        this.copyright = "";
        this.author = "";
        this.date = "";
        this.editor = "";
        this.tagList.clear();
        this.irregularList.clear();
        this.tagSetMap.clear();
    }

    public int getIrregularID(String irregular) {
        return this.irregularList.indexOf(irregular);
    }

    public String getIrregularName(int irregularID) {
        return this.irregularList.get(irregularID);
    }

    public int getTagCount() {
        return this.tagList.size();
    }

    public int getTagID(String tag) {
        return this.tagList.indexOf(tag);
    }

    public String getTagName(int tagID) {
        return this.tagList.get(tagID);
    }

    public int[] getTags(String tagSetName) {
        return this.tagSetMap.get(tagSetName);
    }

    public void init(String filePath, int tagSetFlag) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        this.read(br);
        this.setTagTypes(tagSetFlag);
    }

    public void init(String zipFilePath, String filePathinZip, int tagSetFlag) throws IOException {
        ZipFile zip = new ZipFile(zipFilePath);
        ZipEntry entry = zip.getEntry(filePathinZip);
        InputStream in = zip.getInputStream(entry);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        this.read(br);
        zip.close();
        this.setTagTypes(tagSetFlag);
    }

    private void read(BufferedReader br) throws IOException {
        String line = null;
        this.title = "";
        this.version = "";
        this.copyright = "";
        this.author = "";
        this.date = "";
        this.editor = "";
        this.tagList.clear();
        this.irregularList.clear();
        this.tagSetMap.clear();
        ArrayList<Integer> tempTagNumbers = new ArrayList<Integer>();
        while ((line = br.readLine()) != null) {
            StringTokenizer lineTokenizer = new StringTokenizer(line, "\t");
            if (!lineTokenizer.hasMoreElements()) continue;
            String lineToken = lineTokenizer.nextToken();
            if (lineToken.startsWith("@")) {
                if ("@title".equals(lineToken)) {
                    this.title = lineTokenizer.nextToken();
                    continue;
                }
                if ("@version".equals(lineToken)) {
                    this.version = lineTokenizer.nextToken();
                    continue;
                }
                if ("@copyright".equals(lineToken)) {
                    this.copyright = lineTokenizer.nextToken();
                    continue;
                }
                if ("@author".equals(lineToken)) {
                    this.author = lineTokenizer.nextToken();
                    continue;
                }
                if ("@date".equals(lineToken)) {
                    this.date = lineTokenizer.nextToken();
                    continue;
                }
                if (!"@editor".equals(lineToken)) continue;
                this.editor = lineTokenizer.nextToken();
                continue;
            }
            if ("TAG".equals(lineToken)) {
                this.tagList.add(lineTokenizer.nextToken());
                continue;
            }
            if ("TSET".equals(lineToken)) {
                String tagSetName = lineTokenizer.nextToken();
                StringTokenizer tagTokenizer = new StringTokenizer(lineTokenizer.nextToken(), " ");
                while (tagTokenizer.hasMoreTokens()) {
                    String tagToken = tagTokenizer.nextToken();
                    int tagNumber = this.tagList.indexOf(tagToken);
                    if (tagNumber != -1) {
                        tempTagNumbers.add(tagNumber);
                        continue;
                    }
                    int[] values = this.tagSetMap.get(tagToken);
                    if (values == null) continue;
                    int i = 0;
                    while (i < values.length) {
                        tempTagNumbers.add(values[i]);
                        ++i;
                    }
                }
                int[] tagNumbers = new int[tempTagNumbers.size()];
                Iterator iter = tempTagNumbers.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    tagNumbers[i] = (Integer)iter.next();
                    ++i;
                }
                this.tagSetMap.put(tagSetName, tagNumbers);
                tempTagNumbers.clear();
                continue;
            }
            if (!"IRR".equals(lineToken)) continue;
            this.irregularList.add(lineTokenizer.nextToken());
        }
        br.close();
        this.indexTags = this.tagSetMap.get("index");
        this.unkTags = this.tagSetMap.get("unkset");
        this.iwgTag = this.tagList.indexOf("iwg");
        this.unkTag = this.tagList.indexOf("unk");
        this.numTag = this.tagList.indexOf("nnc");
        this.IRR_TYPE_B = this.getIrregularID("irrb");
        this.IRR_TYPE_S = this.getIrregularID("irrs");
        this.IRR_TYPE_D = this.getIrregularID("irrd");
        this.IRR_TYPE_H = this.getIrregularID("irrh");
        this.IRR_TYPE_REU = this.getIrregularID("irrlu");
        this.IRR_TYPE_REO = this.getIrregularID("irrle");
    }

    public void setTagTypes(int tagSetFlag) {
        if (tagSetFlag == 0) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int[] values = null;
            Iterator iter = null;
            values = this.tagSetMap.get("pv");
            int i = 0;
            while (i < values.length) {
                list.add(values[i]);
                ++i;
            }
            values = this.tagSetMap.get("xsm");
            i = 0;
            while (i < values.length) {
                list.add(values[i]);
                ++i;
            }
            list.add(this.tagList.indexOf("px"));
            this.tagTypeTable[1] = new int[list.size()];
            iter = list.iterator();
            i = 0;
            while (iter.hasNext()) {
                this.tagTypeTable[1][i] = (Integer)iter.next();
                ++i;
            }
            list.clear();
            this.tagTypeTable[2] = this.tagSetMap.get("n");
            this.tagTypeTable[3] = this.tagSetMap.get("np");
            this.tagTypeTable[4] = this.tagSetMap.get("pa");
            this.tagTypeTable[8] = this.tagSetMap.get("e");
            values = this.tagSetMap.get("p");
            i = 0;
            while (i < values.length) {
                list.add(values[i]);
                ++i;
            }
            values = this.tagSetMap.get("xsv");
            i = 0;
            while (i < values.length) {
                list.add(values[i]);
                ++i;
            }
            values = this.tagSetMap.get("xsm");
            i = 0;
            while (i < values.length) {
                list.add(values[i]);
                ++i;
            }
            list.add(this.tagList.indexOf("ep"));
            list.add(this.tagList.indexOf("jp"));
            this.tagTypeTable[7] = new int[list.size()];
            iter = list.iterator();
            i = 0;
            while (iter.hasNext()) {
                this.tagTypeTable[7][i] = (Integer)iter.next();
                ++i;
            }
            list.clear();
            this.tagTypeTable[9] = new int[1];
            this.tagTypeTable[9][0] = this.tagList.indexOf("jp");
            this.tagTypeTable[5] = new int[3];
            this.tagTypeTable[5][0] = this.tagList.indexOf("nbn");
            this.tagTypeTable[5][1] = this.tagList.indexOf("npd");
            this.tagTypeTable[5][2] = this.tagList.indexOf("npp");
            this.tagTypeTable[6] = new int[6];
            this.tagTypeTable[6][0] = this.tagList.indexOf("jxc");
            this.tagTypeTable[6][0] = this.tagList.indexOf("jco");
            this.tagTypeTable[6][0] = this.tagList.indexOf("jca");
            this.tagTypeTable[6][0] = this.tagList.indexOf("jcm");
            this.tagTypeTable[6][0] = this.tagList.indexOf("jcs");
            this.tagTypeTable[6][0] = this.tagList.indexOf("jcc");
        }
    }
}

