% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MdeFunc.R
\name{KoulArMde}
\alias{KoulArMde}
\title{Performs minimum distance estimation in autoregression model.}
\usage{
KoulArMde(X, AR_Order, IntMeasure)
}
\arguments{
\item{X}{: vector of n observed value.}

\item{AR_Order}{: oder of the autoregression model.}

\item{IntMeasure}{- Measure used in integration. It should be either Lebesgue or degenerate.}
}
\value{
returns minimum distance estimators of the parameter in the autoregression model.
}
\description{
Performs minimum distance estimation in autoregression model.
}
\examples{
##### Generate stationary AR(2) process with 10 observations
n <- 10
p <- 2
rho <- c(-0.2, 0.8)    ##### Generate true parameters rho = (-0.2, 0.8)'
eps <- rnorm(n, 0,1)   ##### Generate innovations from N(0,1)
X <- rep(0, times=n)
for (i in 1:n){
 tempCol <- rep(0, times=p)
 for (j in 1:p){
   if(i-j<=0){
     tempCol[j] <- 0
   }else{
     tempCol[j] <- X[i-j]
   }
 }
X[i] <- t(tempCol)\%*\% rho + eps[i]
}
rhohat <- KoulArMde(X, p, "Lebesgue")
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulLrMde()
}

