% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi-attribute-value-functions.R
\name{MAVF_score}
\alias{MAVF_score}
\title{Multi-attribute value function}
\usage{
MAVF_score(x, y, x_wt, y_wt)
}
\arguments{
\item{x}{Numeric vector of values}

\item{y}{Numeric vector of values with compatible dimensions to \code{x}}

\item{x_wt}{Swing weight for \code{x}}

\item{y_wt}{Swing weight for \code{y}}
}
\value{
A vector of the same length as \code{x} and \code{y} with the multi-attribute value scores
}
\description{
\code{MAVF_score} computes the multi-attribute value score of \code{x} and \code{y}
given their respective weights
}
\examples{

# Given the following \\code{x} and \\code{y} attribute values with \\code{x} and
# \\code{y} swing weight values of 0.65 and 0.35 respectively, we can compute
# the multi-attribute utility score:

x_attribute <- c(0.92, 0.79, 1.00, 0.39, 0.68, 0.55, 0.73, 0.76, 1.00, 0.74)
y_attribute <- c(0.52, 0.19, 0.62, 1.00, 0.55, 0.52, 0.53, 0.46, 0.61, 0.84)

MAVF_score(x_attribute, y_attribute, x_wt = .65, y_wt = .35)


}
\seealso{
\code{\link{MAVF_sensitivity}} to perform sensitivity analysis with a range of \code{x} and \code{y} swing weights

\code{\link{SAVF_score}} for computing the exponential single attribute value score
}

