% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LA_LHD.R
\name{LA_LHD}
\alias{LA_LHD}
\title{Lioness Algorithm for Latin hypercube design}
\usage{
LA_LHD(
  n,
  k,
  m = 10,
  N = 10,
  prun = 1/(k - 1),
  OC = "phi_p",
  p = 15,
  q = 1,
  maxtime = 5
)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{m}{A positive integer, which stands for the number of starting lionesses agents. The default is set to be 10, and it is recommended to be no greater than 100.}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 10. A large value of \code{N} will result a high CPU time, and it is recommended to be no greater than 500.}

\item{prun}{A probability, which stands for the probability of "prey runs away", and it is denoted as \code{p*} in the original paper. The default is set to be 1/(\code{k} - 1).}

\item{OC}{An optimality criterion. The default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".}

\item{p}{A positive integer, which is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, the Manhattan (rectangular) distance will be used. If \code{q} is 2, the Euclidean distance will be used.}

\item{maxtime}{A positive number, which indicates the expected maximum CPU time given by user, and it is measured by minutes. For example, maxtime=3.5 indicates the CPU time will be no greater than three and half minutes. The default is set to be 5.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{LA_LHD} returns a \code{n} by \code{k} Latin hypercube design matrix generated by lioness algorithm (LA)
}
\examples{
#generate a 6 by 3 maximin distance LHD with the default setting
try=LA_LHD(n=6,k=3)
try
LHD::phi_p(try)   #calculate the phi_p of "try".

#Another example
#generate a 9 by 4 nearly orthogonal LHD
try2=LA_LHD(n=9,k=4,OC="AvgAbsCor")
try2
LHD::AvgAbsCor(try2)  #calculate the average absolute correlation.
}
