
<!-- README.md is generated from README.Rmd. Please edit that file -->

# LAWBL: Latent (Variable) Analysis With Bayesian Learning

[![Project Status: Active ? The project has reached a stable, usable
state and is being actively
developed.](http://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/)
[![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/LAWBL)](https://cran.r-project.org/package=LAWBL)
[![](https://cranlogs.r-pkg.org/badges/LAWBL?color=brightgreen)](https://cran.r-project.org/package=LAWBL)
[![](http://cranlogs.r-pkg.org/badges/grand-total/LAWBL?color=green)](https://cran.r-project.org/package=LAWBL)

## How to cite the package

Chen, J. (2021). LAWBL: Latent (variable) analysis with Bayesian
learning (R package version 1.4.0). Retrieved from
<https://CRAN.R-project.org/package=LAWBL>

## Introduction

**LAWBL** represents a partially exploratory-confirmatory approach to
model latent variables based on Bayesian learning. Built on the power of
statistical learning, it can address psychometric challenges such as
parameter specification, local dependence, and factor extraction. Built
on the scalability and flexibility of Bayesian inference and resampling
techniques, it can accommodate modeling frameworks such as factor
analysis, item response theory, cognitive diagnosis modeling and causal
or explanatory modeling. The package can also handle different response
formats or a mix of them, with or without missingness.

## Features

  - Partially CFA (PCFA) for continuous data: regularization of loading
    specification and local dependence; PCFA with local independence
    (PCFA-LI); CFA with local dependence (CFA-LD)
  - Generalized PCFA (GPCFA) for continuous, categorical, or mixed-type
    data, with or without missingness; GPCFA with local independence
    (GPCFA-LI); Generalized CFA with local dependence (GCFA-LD)
  - Partially confirmatory item response model (PCIRM) for continuous
    and dichotomous data with intercept terms; PCIRM-LI; CIRM-LD
  - Bayesian regularized EFA (BREFA): factor extraction and parameter
    estimation in one step; Fully and partially EFA: unknown number of
    factors without or with partial knowledge
  - Estimation using different Bayesian learning methods and MCMC
    algorithms
  - Simulating data based on all aforementioned models
  - Plotting trace, density or Gelman-Rubin diagnostics based on
    eigenvalue
  - Summary of all parameters with both point and interval estimates

Please refer to the [online
tutorials](https://jinsong-chen.github.io/LAWBL/articles/LAWBL.html) for
more details.

## Installation

1)  Install the stable version from [CRAN](https://CRAN.R-project.org)
    with:

<!-- end list -->

``` r
install.packages("LAWBL")
```

2)  Install the `devtools` package (if necessary), and install the
    development version from the Github.

<!-- end list -->

``` r
# install.packages("devtools")
devtools::install_github("Jinsong-Chen/LAWBL")
```
