% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mrgsn.R
\name{mrgsn.plot}
\alias{mrgsn.plot}
\title{This functions plot the Dataset and its Fitted curve}
\usage{
\method{mrgsn}{plot}(XYdt, xlbl = "Salt Fraction (w/w)",
  ylbl = "PEG Fraction (w/w)", main = "Title", col = "blue", type = "p",
  cex = 2.5, cexlab = 2.5, cexaxis = 2.5, cexmain = 2.5, cexsub = 2.5,
  xmax = 0.4, ymax = 0.5, ...)
}
\arguments{
\item{XYdt}{- Standard bidimensional data.frame used in most of functions available in this package. [type::data.frame]}

\item{xlbl}{- Plot's Horizontal axis label. If not set, It will admit the system under study is a PEG-Salt System.   [type:string]}

\item{ylbl}{- Plot's Vertical axis label. If not set, It will admit the system under study is a PEG-Salt System.   [type:string]}

\item{main}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{col}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{type}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cex}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexlab}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexaxis}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexmain}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexsub}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{xmax}{- Maximum value for the Horizontal axis' value  [type:double]}

\item{ymax}{- Maximum value for the Vertical axis' value  [type:double]}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
A plot containing the experimental data and the correspondent curve for the binodal in study.
}
\description{
The function returns a plot after fitting a dataset to the equation described by Murugesan.
}
\details{
This version uses the plot function and return a regular bidimensional plot. Future versions will
 include a ternary diagram and more formal formatting.
}
\examples{
#Populating variable XYdt with binodal data
XYdt <- peg4kslt[,1:2]
#Plot XYdt using Murugesan's function
\dontrun{
mrgsn.plot(XYdt)
}
}

