% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSysPlot.R
\name{AQSysPlot}
\alias{AQSysPlot}
\title{This functions plot a curve based in the chosen model and its parameters.}
\usage{
AQSysPlot(dataSET, xlbl, ylbl, seriesNames = NULL, save = FALSE,
  filename = NULL, HR = FALSE, wdir = NULL, silent = FALSE)
}
\arguments{
\item{dataSET}{- Binodal Experimental data that will be used in the nonlinear fit. It might hold multiple systems stacked side-by-side. [type:data.frame]}

\item{xlbl}{Plot's Horizontal axis label.}

\item{ylbl}{Plot's Vertical axis label.}

\item{seriesNames}{A list of sequential names which will identify each system provided by the user in the dataSET variable. [type:List]}

\item{save}{Save the generated plot in the disk using path and filename provided by the user. Default is False. [type:Logical]}

\item{filename}{A filename provided by the user to save a given plot. No default is provided. [type:String]}

\item{HR}{Adjust Plot's text to be compatible with High Resolution size [type:Logical]}

\item{wdir}{The directory in which the plot file will be saved. [type:String]}

\item{silent}{save plot file without actually showing it to the user. Default is FALSE. [type:Logical]}
}
\description{
The function returns a plot after using the parameters and model given by the user.
}
\details{
The function owns predefined set of equations that can be seen below and must be used, with adequated parameters,
to return a plot which represent the chosen model.
}
