% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.anova_lmm.R
\name{confint.anova_lmm}
\alias{confint.anova_lmm}
\title{Confidence Intervals for Multivariate Wald Tests}
\usage{
\method{confint}{anova_lmm}(object, parm, level = 0.95, method = NULL, simplify = TRUE, ...)
}
\arguments{
\item{object}{a \code{anova_lmm} object}

\item{parm}{Not used. For compatibility with the generic method.}

\item{level}{[numeric, 0-1] nominal coverage of the confidence intervals.}

\item{method}{[character] type of adjustment for multiple comparisons: one of \code{"none"}, \code{"bonferroni"}, \code{"single-step"}, \code{"single-step2"}.}

\item{simplify}{[logical] Return a data.frame instead of a list containing a data.frame when possible.}

\item{...}{Not used. For compatibility with the generic method.}
}
\description{
Compute confidence intervals for linear hypothesis tests, possibly with adjustment for multiple comparisons.
}
\details{
Method \code{"single-step"} adjust for multiple comparisons using quantiles of the multivariate Student's t-distribution, assuming equal degrees of freedom in the marginal.
This is performed by the multcomp package.

When degrees of freedom differs between individual hypotheses, method \code{"single-step2"} is recommended. It simulates data using copula whose marginal distributions are Student's t-distribution (with possibly different degrees of freedom) and elliptical copula with parameters the estimated correlation between the test statistics. This is performed by the copula package.
}
