% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RocPlot.R
\name{RocPlot}
\alias{RocPlot}
\title{ROC Curves Plot}
\usage{
RocPlot(ModelObject, testdata, outcome, reflevel)
}
\arguments{
\item{ModelObject}{An object obtained from TreeModels() or TreeModelsAllSteps() functions.}

\item{testdata}{A testing dataset.}

\item{outcome}{A character string with the name of the binary outcome variable.}

\item{reflevel}{A character string with the quoted reference level of outcome.}
}
\value{
This function returns a plot with ROC curves for the selected tree-based models (i.e., decision tree, random forest, or gradient boosting).
}
\description{
ROC Curves Plot
}
\examples{
\donttest{
colnames(training)[14] <- "perf"
colnames(testing)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("dt", "gbm","rf"),checkprogress = TRUE)

RocPlot(ModelObject = ensemblist$ModelObject, testdata = testing,
outcome = "perf", reflevel = "incorrect")
}
}
