% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medcouple_estimator.R
\name{medcouple_estimator}
\alias{medcouple_estimator}
\title{MedCouple Estimator}
\usage{
medcouple_estimator(x, seed = sample.int(1e+06, 1))
}
\arguments{
\item{x}{numeric vector; if length > 3,000, it uses a random subsample
(otherwise it takes too long to compute as calculations are of order
\eqn{N^2}.)}

\item{seed}{numeric; seed used for sampling (when \code{length(x) >
3000}).}
}
\value{
float; measures the degree of asymmetry
}
\description{
A robust measure of asymmetry. See References for details.
}
\examples{

# a simulation
kNumSim <- 100
kNumObs <- 200

################# Gaussian (Symmetric) #### 
A <- t(replicate(kNumSim, {xx <- rnorm(kNumObs); c(skewness(xx), medcouple_estimator(xx))}))
########### skewed LambertW x Gaussian #### 
tau.s <- gamma_01(0.2) # zero mean, unit variance, but positive skewness
rbind(mLambertW(theta = list(beta = tau.s[c("mu_x", "sigma_x")], 
                             gamma = tau.s["gamma"]), 
                distname="normal"))
B <- t(replicate(kNumSim, 
                 {
                   xx <- rLambertW(n = kNumObs, 
                                   theta = list(beta = tau.s[c("mu_x", "sigma_x")], 
                                                gamma = tau.s["gamma"]), 
                                   distname="normal")
                   c(skewness(xx), medcouple_estimator(xx))
                 }))
                  
colnames(A) <- colnames(B) <- c("MedCouple", "Pearson Skewness")

layout(matrix(1:4, ncol = 2))
plot(A, main = "Gaussian")
boxplot(A)
abline(h = 0)

plot(B, main = "Skewed Lambert W x Gaussian")
boxplot(B)
abline(h = mLambertW(theta = list(beta = tau.s[c("mu_x", "sigma_x")], 
                                  gamma = tau.s["gamma"]), 
                     distname="normal")["skewness"])

colMeans(A)
apply(A, 2, sd)

colMeans(B)
apply(B, 2, sd)

}
\references{
Brys, G., M. Hubert, and A. Struyf (2004). \dQuote{A robust
    measure of skewness}. Journal of Computational and Graphical Statistics
    13 (4), 996 - 1017.
}
\seealso{
\code{\link{test_symmetry}}
}
\keyword{univar}
