% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadpoints.R
\name{quadpoints}
\alias{quadpoints}
\title{Quadrature points}
\usage{
quadpoints(dim, quad_tech = "Gaussian", quad_points = NULL)
}
\arguments{
\item{dim}{Dimension of the quadrature}

\item{quad_tech}{A string to specify the quadrature calculation technique. Use "Gaussian" to use that method, or
or "QMCEM" for Quasi-Monte Carlo quadrature.}

\item{quad_points}{An integer number specifying the amount of quadrature points to use. If NULL, the program will choose the best one.
If Quasi-Monte Carlo method is specified, the default value is of 2000 points.}
}
\description{
Return a list with quadrature points according to dimensionality, technique
and number of points.
}
\examples{
\dontrun{qp = quadpoints(dim = 4,quad_tech = "QMCEM",quad_points = 3000)}
}

