% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/inver_calib.R
\name{inver.calib}
\alias{inver.calib}
\title{Inverse Linear Calibration Function}
\usage{
inver.calib(x, y, alpha, y0)
}
\arguments{
\item{x}{numerical vector of regressor measurments}

\item{y}{numerical vector of observation measurements}

\item{alpha}{the confidence interval to be calculated}

\item{y0}{vector of observed calibration value}
}
\description{
\code{inver.calib} uses the inverse frequentist approach to estimate an unknown X given observed vector y0 and calculates confidence interval estimates.
}
\examples{
X <- c(1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10)
Y <- c(1.8,1.6,3.1,2.6,3.6,3.4,4.9,4.2,6.0,5.9,6.8,6.9,8.2,7.3,8.8,8.5,9.5,9.5,10.6,10.6)

inver.calib(X,Y,0.05,6)
}
\references{
Krutchkoff, R. G. (1967). Classical and Inverse Regression Methods of Calibration. Technometrics. 9, 425-439.
}
\keyword{calibration}
\keyword{linear}

