% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalProcessing.R
\name{annotateIsotopes}
\alias{annotateIsotopes}
\title{Annotate isotopes}
\usage{
annotateIsotopes(
  peaklist,
  rawScans,
  dmz,
  drt,
  massdiff,
  charge,
  isotopeAb,
  m0mass,
  corThr,
  checkInt,
  checkCor
)
}
\arguments{
\item{peaklist}{extracted peaks. Data.frame with 4 columns (mz, RT, int
and peakID).}

\item{rawScans}{raw scan data. Data.frame with 5 columns (mz, RT, int,
peakID and Scan).}

\item{dmz}{mass tolerance in ppm.}

\item{drt}{RT windows with the same units used in peaklist.}

\item{massdiff}{mass difference.}

\item{charge}{charge.}

\item{isotopeAb}{isotope natural abundance.}

\item{m0mass}{mass of the most abundant naturally occurring stable isotope.}

\item{corThr}{peak correlation threshold.}

\item{checkInt}{logical. If TRUE, relative intensity is checked.}

\item{checkCor}{logical. If TRUE, peaks correlation is checked.}
}
\value{
peaklist with 6 columns (mz, RT, int, peakID, isotope and isoGroup).
}
\description{
Annotate isotopes based on mass differences, retention time and peak
correlation if required.
}
\author{
M Isabel Alcoriza-Balaguer <maialba@iislafe.es>
}
\keyword{internal}
