ui <- tagList(
  navbarPage(
    position = "fixed-top",
    theme = shinythemes::shinytheme("flatly"),
    title = div(img(src='iconohorizontal.png',style="margin-top: -14px; padding-right:0px; padding-left:0px; padding-bottom:10px", height = 60, width = 100)),
    windowTitle = "LipidMS",
    id = "inTabset",
    tabPanel(title = "Data import", value = "tab1",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             sidebarPanel(width = 3,
                          fluidRow(textInput("jobname", "Job Name",
                                 value = paste("Job", as.character(Sys.Date()), sep = "_")),
                                 style = "margin: 20px 0px 0px 0px"),
                          fluidRow(radioButtons("analysis", "How do you want to process your data?",
                                    choices = c("Batch Processing" = "batch",
                                                "Single Sample Processing" = "single"),
                                    selected = "batch"),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(column(4, textOutput("messageanalysis"), style="color:red")),
                          fluidRow(radioButtons("sI_polarity", "Polarity",
                                                       choices = c("Positive" = "positive",
                                                                   "Negative" = "negative"),
                                                       selected = "positive"),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(fileInput("file1", "Choose mzXML File/s",
                                 multiple = TRUE,
                                 accept = c("text/plain",
                                            ".mzXML")),
                                 style = "margin: 20px 0px 0px 0px"),
                          fluidRow(fileInput("metadata", "Metadata csv file",
                                 multiple = TRUE,
                                 accept = c("text/plain",
                                            ".csv")),
                                 h6(em("It must be a csv file with 3 columns:\n",
                                       "sample (mzXML file names),\n",
                                       "acquisitionmode (MS, DIA or DDA) and\n",
                                       "sampletype (QC, group1, group2, etc.)"), style = "color:grey"),
                                 style = "margin: 20px 0px 0px 0px"),
                          fluidRow(fileInput("metadata", "Metadata csv file",
                                             multiple = FALSE,
                                             accept = c("text/plain",
                                                        ".csv")),
                                   h6(em("It must be a csv file with 3 columns:\n",
                                         "sample (mzXML file names),\n",
                                         "acquisitionmode (MS, DIA or DDA) and\n",
                                         "sampletype (QC, group1, group2, etc.)"), style = "color:grey"),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(column(4, h5(strong("sep")),
                                          h6(em("column delimiter."), style = "color:grey")),
                                   column(3, textInput("sep1", "", value=","))),
                          fluidRow(column(4, h5(strong("dec")),
                                          h6(em("decimal character."), style = "color:grey")),
                                   column(3, textInput("dec1", "", value="."))),
                          tags$hr(style = "border-color: white"),
                          fluidRow(actionButton("JumpTo2", "Next >", width = "100px"),
                                   style = "margin: 20px 0px 0px 0px")
            ),
            mainPanel(tableOutput("metadata"))
    ),
    tabPanel(title = "Peak-picking", value = "tab2",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             tags$head(
               tags$style(HTML("input[type=\"number\"] {
                               height: 35px; font-size:11px
                               }"))),
             mainPanel(
               position="left",
               fluidRow(column(6, h5(strong("dmzagglom (in ppm)")),
                               h6(em("m/z tolerance used for partitioning and clustering. 5 by default."), style = "color:grey")),
                        column(3, numericInput("dmzagglom_ms1", "MS1", value = 15, min = 0, max = 100, step = 1)),
                        column(3, numericInput("dmzagglom_ms2", "MS2", value = 15, min = 0, max = 100, step = 1))),
               fluidRow(column(6, h5(strong("drtagglom (in seconds)")),
                               h6(em("rt window used for partitioning (in seconds). 25 by default."), style = "color:grey")),
                        column(3, numericInput("drtagglom_ms1", "MS1", value = 500, min = 0, max = 1000, step = 1)),
                        column(3, numericInput("drtagglom_ms2", "MS2", value = 500, min = 0, max = 1000, step = 1))),
               fluidRow(column(6, h5(strong("drtclust (in seconds)")),
                               h6(em("rt window used for clustering (in seconds). 25 by default."), style = "color:grey")),
                        column(3, numericInput("drtclust_ms1", "MS1", value = 100, min = 0, max = 1000, step = 1)),
                        column(3, numericInput("drtclust_ms2", "MS2", value = 200, min = 0, max = 1000, step = 1))),
               fluidRow(column(6, h5(strong("minpeak")),
                               h6(em("minimum number of measurements required for a peak. By default, 5 for MS1 and 4 for MS2."), style = "color:grey")),
                        column(3, numericInput("minpeak_ms1", "MS1", value = 5, min = 1, max = 25, step = 1)),
                        column(3, numericInput("minpeak_ms2", "MS2", value = 4, min = 1, max = 25, step = 1))),
               fluidRow(column(6, h5(strong("minint")),
                               h6(em("minimum intensity of a peak. By default, 1000 for MS1 and 100 for MS2."), style = "color:grey")),
                        column(3, numericInput("minint_ms1", "MS1", value = 1000, min = 0, max = 1e5, step = 1)),
                        column(3, numericInput("minint_ms2", "MS2", value = 100, min = 0, max = 1e5, step = 1))),
               fluidRow(column(6, h5(strong("drtgap (in seconds)")),
                               h6(em("maximum rt gap length to be filled. 5 by default."), style = "color:grey")),
                        column(3, numericInput("drtgap_ms1", "MS1", value = 5, min = 0, max = 30, step = 1)),
                        column(3, numericInput("drtgap_ms2", "MS2", value = 5, min = 0, max = 30, step = 1))),
               fluidRow(column(6, h5(strong("drtminpeak (in seconds)")),
                               h6(em("minimum rt width of a peak. 15 by default. At least minpeak within the drtminpeak window are required to define a peak."), style = "color:grey")),
                        column(3, numericInput("drtminpeak_ms1", "MS1", value = 15, min = 0, max = 500, step = 1)),
                        column(3, numericInput("drtminpeak_ms2", "MS2", value = 15, min = 0, max = 500, step = 1))),
               fluidRow(column(6, h5(strong("drtmaxpeak (in seconds)")),
                               h6(em("maximum rt width of a single peak. 100 by default."), style = "color:grey")),
                        column(3, numericInput("drtmaxpeak_ms1", "MS1", value = 100, min = 0, max = 500, step = 1)),
                        column(3, numericInput("drtmaxpeak_ms2", "MS2", value = 200, min = 0, max = 500, step = 1))),
               fluidRow(column(6, h5(strong("maxeicpeaks")),
                               h6(em("maximum number of peaks within one EIC. By default, 5 for 10 and 3 for MS2."), style = "color:grey")),
                        column(3, numericInput("recurs_ms1", "MS1", value = 5, min = 1, max = 50, step = 1)),
                        column(3, numericInput("recurs_ms2", "MS2", value = 10, min = 1, max = 50, step = 1))),
               fluidRow(column(6, h5(strong("weight")),
                               h6(em("weight for assigning measurements to a peak. By default, 2 for MS1 and 3 for MS2."), style = "color:grey")),
                        column(3, numericInput("weight_ms1", "MS1", value = 2, min = 1, max = 10, step = 1)),
                        column(3, numericInput("weight_ms2", "MS2", value = 3, min = 1, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("SN")),
                               h6(em("signal-to-noise ratio. By default, 3 for MS1 and 2 for MS2."), style = "color:grey")),
                        column(3, numericInput("sn_ms1", "MS1", value = 3, min = 1, max = 10, step = 1)),
                        column(3, numericInput("sn_ms2", "MS2", value = 2, min = 1, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("SB")),
                               h6(em("signal-to-base ratio. By default, 3 for MS1 and 2 for MS2."), style = "color:grey")),
                        column(3, numericInput("sb_ms1", "MS1", value = 3, min = 1, max = 10, step = 1)),
                        column(3, numericInput("sb_ms2", "MS2", value = 2, min = 1, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("dmzIso (in ppm)")),
                               h6(em("mass tolerance for isotope matching. 5 by default."), style = "color:grey")),
                        column(3, numericInput("dmzIso_ms1", "MS1", value = 5, min = 0, max = 100, step = 1)),
                        column(3, numericInput("dmzIso_ms2", "MS2", value = 5, min = 0, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("drtIso")),
                               h6(em("rt window for isotope matching. 5 by default."), style = "color:grey")),
                        column(3, numericInput("drtIso_ms1", "MS1", value = 5, min = 0, max = 100, step = 1)),
                        column(3, numericInput("drtIso_ms2", "MS2", value = 5, min = 0, max = 100, step = 1))),
               tags$hr(),
               fluidRow(actionButton("GoBackTo1", "< Previous", width = "100px", 
                                     style="margin:40px 0px"), 
                        actionButton("JumpTo3", "Next >", width = "100px", 
                                     style="margin:40px 0px"))
             )),
    tabPanel(title = "Batch processing", value = "tab3",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             tags$head(
               tags$style(HTML("input[type=\"number\"] {
                               height: 35px; font-size:11px
                               }"))),
             mainPanel(fluidRow(column(6, h5(strong("dmzalign")),
                                       h6(em("mass tolerance between peak groups for alignment (in ppm). 5 by default."), style = "color:grey")),
                                column(3, numericInput("dmzalign", "", value = 5, min = 0, max = 100, step = 1))),
                       fluidRow(column(6, h5(strong("drtalign")),
                                       h6(em("maximum rt distance between peaks for alignment (in seconds). 30 by default."), style = "color:grey")),
                                column(3, numericInput("drtalign", "", value = 30, min = 0, max = 200, step = 1))),
                       fluidRow(column(6, h5(strong("span")),
                                       h6(em("span parameter for loess rt smoothing. 0.4 by default."), style = "color:grey")),
                                column(3, numericInput("span", "", value = 0.4, min = 0, max = 1, step = 0.05))),
                       fluidRow(column(6, h5(strong("minsamplesfracalign")),
                                       h6(em("minimum samples fraction represented in each cluster used for alignment. 0.75 by default."), style = "color:grey")),
                                column(3, numericInput("minsamplesfracalign", "", value = 0.75, min = 0, max = 1, step = 0.05))),
                       fluidRow(column(6, h5(strong("dmzgroup")),
                                       h6(em("mass tolerance between peak groups for grouping (in ppm). 5 by default."), style = "color:grey")),
                                column(3, numericInput("dmzgroup", "", value = 5, min = 0, max = 100, step = 1))),
                       fluidRow(column(6, h5(strong("drtagglomgroup")),
                                       h6(em("maximum rt distance in mz partitions for grouping (in seconds). 30 by default. It shouldn't be smaller than drtgroup."), style = "color:grey")),
                                column(3, numericInput("drtagglomgroup", "", value = 30, min = 0, max = 200, step = 1))),
                       fluidRow(column(6, h5(strong("drtgroup")),
                                       h6(em("maximum rt distance between peaks for grouping (in seconds). 30 by default."), style = "color:grey")),
                                column(3, numericInput("drtgroup", "", value = 15, min = 0, max = 200, step = 1))),
                       fluidRow(column(6, h5(strong("minsamplesfracgroup")),
                                       h6(em("minimum samples fraction represented in each cluster used for grouping. 0.25 by default."), style = "color:grey")),
                                column(3, numericInput("minsamplesfracgroup", "", value = 0.25, min = 0, max = 1, step = 0.05))),
                       fluidRow(column(6, h5(strong("parallel")),
                                       h6(em("parallelize processing. FALSE by default."), style = "color:grey")),
                                column(3, selectInput("parallel", "", choices = list("TRUE" = TRUE, "FALSE" = FALSE), 
                                                      selected = FALSE))),
                       fluidRow(column(6, h5(strong("ncores")),
                                       h6(em("number of cores to be used in case parallel is TRUE. 2 by default."), style = "color:grey")),
                                column(3, numericInput("ncores", "", value = 2, min = 0, max = 50, step = 1))),
                       tags$hr(),
                       fluidRow(actionButton("GoBackTo2", "< Previous", width = "100px", 
                                             style="margin:40px 0px"), 
                                actionButton("JumpTo4", "Next >", width = "100px", 
                                             style="margin:40px 0px"))
             )),
    tabPanel(title = "Annotation", value = "tab4",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             mainPanel(fluidRow(column(6, h5(strong("dmzprecursor")),
                                       h6(em("mass tolerance for precursor ions. 5 by default."), style = "color:grey")),
                                column(3, numericInput("dmzprecursor", "", value = 5, min = 0, max = 100, step = 1))),
                       fluidRow(column(6, h5(strong("dmzproducts")),
                                       h6(em("mass tolerance for product ions. 10 by default."), style = "color:grey")),
                                column(3, numericInput("dmzproducts", "", value = 10, min = 0, max = 100, step = 1))),
                       fluidRow(column(6, h5(strong("rttol")),
                                       h6(em("total rt window for coelution between precursor and product ions. 5 by default."), style = "color:grey")),
                                column(3, numericInput("rttol", "", value = 5, min = 0, max = 50, step = 1))),
                       fluidRow(column(6, h5(strong("coelcutoff")),
                                       h6(em("coelution score threshold between parent and fragment ions. Only applied if rawData info is supplied. 0.7 by default."), style = "color:grey")),
                                column(3, numericInput("coelcutoff", "", value = 0.7, min = 0, max = 1, step = 0.05))),
                       tags$hr(),
                       fluidRow(column(6, checkboxGroupInput("lipidClassesPos", "Lipid classes to annotate for ESI+ :",
                                                             c("MG" = "MG",
                                                               "LPC" = "LPC",
                                                               "LPE" = "LPE",
                                                               "PC" = "PC",
                                                               "PCo" = "PCo",
                                                               "PCp" = "PCp",
                                                               "PE" = "PE",
                                                               "PEo" = "PEo",
                                                               "PEp" = "PEp",
                                                               "PG" = "PG",
                                                               "Sphingoid bases" = "Sph",
                                                               "Sphingoid bases phosphate" = "SphP",
                                                               "Cer" = "Cer",
                                                               "AcylCer" = "AcylCer",
                                                               "CerP" = "CerP",
                                                               "SM" = "SM",
                                                               "Carnitines" = "Carnitines",
                                                               "CE" = "CE",
                                                               "DG" = "DG",
                                                               "TG" = "TG"),
                                                             selected = c("MG", "LPC", "LPE", "PC", "PCo", "PCp", "PE", "PEo", "PEp", "PG", "Sph",
                                                                          "SphP", "Cer", "AcylCer", "CerP", "SM", "Carnitines", "CE", "DG", "TG"))),
                                column(6, checkboxGroupInput("lipidClassesNeg", "Lipid classes to annotate for ESI+ :",
                                                             c("FA" = "FA",
                                                               "FAHFA" = "FAHFA",
                                                               "LPC" = "LPC",
                                                               "LPE" = "LPE",
                                                               "LPG" = "LPG",
                                                               "LPI" = "LPI",
                                                               "LPS" = "LPS",
                                                               "PC" = "PC",
                                                               "PCo" = "PCo",
                                                               "PCp" = "PCp",
                                                               "PE" = "PE",
                                                               "PEo" = "PEo",
                                                               "PEp" = "PEp",
                                                               "PG" = "PG",
                                                               "PI" = "PI",
                                                               "PS" = "PS",
                                                               "Sphingoid bases" = "Sph",
                                                               "Sphingoid bases phosphate" = "SphP",
                                                               "Cer" = "Cer",
                                                               "AcylCer" = "AcylCer",
                                                               "CerP" = "CerP",
                                                               "CL" = "CL",
                                                               "Bile Acids" = "BA"),
                                                             selected = c("FA", "FAHFA", "LPC", "LPE", "LPG", "LPI", "LPS", 
                                                                          "PC", "PCo", "PCp", "PE", "PEo", "PEp", "PG", "PI", "PS", 
                                                                          "Sph", "SphP", "Cer", "AcylCer", "CerP", "CL", "BA")))),
                       tags$hr(),
                       fluidRow(actionButton("GoBackTo3", "< Previous", width = "100px", 
                                             style="margin:40px 0px"), 
                                actionButton("JumpTo5", "Next >", width = "100px", 
                                             style="margin:40px 0px"))
                       )),
    tabPanel(title = "Run", value = "tab5",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             sidebarPanel(width = 3,
                          fluidRow(h5("\nRun your job: "),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(actionButton("do", "Run", 
                                                style="color: #fff; background-color: #669999; border-color: #000"),
                                   style = "margin: 20px 0px 0px 0px"),
                          tags$hr(style = "border-color: white"),
                          fluidRow(h5("\nDownload your results: "),
                                   h6(em("(Wait until your results show up on the main panel)")),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(downloadButton("downloadSummary", "Summary Tables", 
                                                  style="color: #fff; background-color: #669999; border-color: #000"),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(downloadButton("downloadPeaklist", "Annotated Peaklists", 
                                                  style="color: #fff; background-color: #669999; border-color: #000"),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(downloadButton("downloadBatchResults", "Batch Results (if applied)", 
                                                  style="color: #fff; background-color: #669999; border-color: #000"),
                                   style = "margin: 20px 0px 0px 0px"),
                          fluidRow(downloadButton("downloadPlots", "Plots", 
                                                  style="color: #fff; background-color: #669999; border-color: #000"),
                                   style = "margin: 20px 0px 0px 0px"),
                          tags$hr(style = "border-color: white"),
                          fluidRow(actionButton("GoBackTo4", "< Previous", width = "100px", 
                                       style="margin:40px 0px"),
                                   style = "margin: 20px 0px 0px 0px")
             ),
             mainPanel(
               tabsetPanel(type = "tabs",
                           tabPanel("Summary Tables Annotation", tableOutput("summaryTable")),
                           tabPanel("Annotated Peaklists", tableOutput("annotatedPeaklist")),
                           tabPanel("Batch Results", tableOutput("features"))
                           )
             ))
  )
)
