% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR-summary.R
\name{summary.LR}
\alias{summary.LR}
\title{Summary for the Lorenz Regression}
\usage{
\method{summary}{LR}(object, ...)
}
\arguments{
\item{object}{Output of a call to \code{\link{Lorenz.Reg}}, where \code{penalty=="none"}.}

\item{...}{Additional arguments}
}
\value{
A summary displaying the explained Gini coefficient, Lorenz-\eqn{R^2} and a table gathering the estimated coefficients, including p-values if bootstrap was performed.
}
\description{
\code{summary.LR} provides a summary for an object of class \code{LR}.
}
\examples{
data(Data.Incomes)
NPLR <- Lorenz.Reg(Income ~ ., data = Data.Incomes, penalty = "none")
summary(NPLR)

}
\seealso{
\code{\link{Lorenz.Reg}}
}
