% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{BaseDataSet.CosmicDoseRate}
\alias{BaseDataSet.CosmicDoseRate}
\title{Base data set for cosmic dose rate calculation}
\format{\tabular{ll}{

\code{values.cosmic.Softcomp}: \tab data frame containing cosmic dose rates
for shallow depths (< 167 g cm^-2) obtained using the "AGE" program by
Rainer Gruen (cf. Gruen 2009). These data essentially reproduce the graph
shown in Fig. 1 of Prescott & Hutton (1988). \cr

\code{values.factor.Altitude}: \tab data frame containing altitude factors
for adjusting geomagnetic field-change factors. Values were read from Fig. 1
in Prescott & Hutton (1994). \cr

\code{values.par.FJH}: \tab data frame containing values for parameters F, J
and H (read from Fig. 2 in Prescott & Hutton 1994) used in the expression }

\deqn{Dc = D0*(F+J*exp((altitude/1000)/H))}}
\source{
The following data were carefully read from figures in mentioned
sources and used for fitting procedures. The derived expressions are used in
the function \code{calc_CosmicDoseRate}.

\bold{values.cosmic.Softcomp}

\tabular{ll}{

Program: \tab "AGE"\cr Reference: \tab Gruen (2009) \cr Fit: \tab
Polynomials in the form of

}

For depths between 40-167 g cm^-2:

\deqn{y = 2*10^-6*x^2-0.0008*x+0.2535}

(For depths <40 g cm^-2)

\deqn{y = -6*10^-8*x^3+2*10^-5*x^2-0.0025*x+0.2969}

\bold{values.factor.Altitude}

\tabular{ll}{

Reference: \tab Prescott & Hutton (1994) \cr Page: \tab 499 \cr Figure: \tab
1 \cr Fit: \tab 2-degree polynomial in the form of

}

\deqn{y = -0.026*x^2 + 0.6628*x + 1.0435}

\bold{values.par.FJH}

\tabular{ll}{

Reference: \tab Prescott & Hutton (1994) \cr Page: \tab 500 \cr Figure: \tab
2 \cr Fits: \tab 3-degree polynomials and linear fits

}

F (non-linear part, \eqn{\lambda} < 36.5 deg.):

\deqn{y = -7*10^-7*x^3-8*10^-5*x^2-0.0009*x+0.3988}

F (linear part, \eqn{\lambda} > 36.5 deg.):

\deqn{y = -0.0001*x + 0.2347}

J (non-linear part, \eqn{\lambda} < 34 deg.):

\deqn{y = 5*10^-6*x^3-5*10^-5*x^2+0.0026*x+0.5177}

J (linear part, \eqn{\lambda} > 34 deg.):

\deqn{y = 0.0005*x + 0.7388}

H (non-linear part, \eqn{\lambda} < 36 deg.):

\deqn{y = -3*10^-6*x^3-5*10^-5*x^2-0.0031*x+4.398}

H (linear part, \eqn{\lambda} > 36 deg.):

\deqn{y = 0.0002*x + 4.0914}
}
\description{
Collection of data from various sources needed for cosmic dose rate
calculation
}
\section{Version}{
 0.1
}
\examples{
##load data
data(BaseDataSet.CosmicDoseRate)
}
\references{
Gruen, R., 2009. The "AGE" program for the calculation of luminescence age estimates.
Ancient TL, 27, pp. 45-46.

Prescott, J.R., Hutton, J.T., 1988. Cosmic ray and gamma ray dosimetry for
TL and ESR. Nuclear Tracks and Radiation Measurements, 14, pp. 223-227.

Prescott, J.R., Hutton, J.T., 1994. Cosmic ray contributions to dose rates
for luminescence and ESR dating: large depths and long-term time variations.
Radiation Measurements, 23, pp. 497-500.
}
\keyword{datasets}

