% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readBIN2R.R
\name{readBIN2R}
\alias{readBIN2R}
\title{Import Risoe BIN-file into R}
\usage{
readBIN2R(file, show.raw.values = FALSE, n.records, fastForward = FALSE,
  show.record.number = FALSE, txtProgressBar = TRUE, forced.VersionNumber)
}
\arguments{
\item{file}{\link{character} (\bold{required}): bin-file name (including
path), e.g. \cr [WIN]: \code{readBIN2R("C:/Desktop/test.bin")}, \cr
[MAC/LINUX]: \code{readBIN2R("/User/test/Desktop/test.bin")}}

\item{show.raw.values}{\link{logical} (with default): shows raw values from
BIN file for \code{LTYPE}, \code{DTYPE} and \code{LIGHTSOURCE} without
translation in characters.}

\item{n.records}{\link{raw} (optional): limits the number of imported
records. Can be used in combination with \code{show.record.number} for
debugging purposes, e.g. corrupt BIN files.}

\item{fastForward}{\code{\link{logical}} (with default): if \code{TRUE} for a
more efficient data processing only a list of \code{RLum.Analysis} objects is returned instead
of a \link{Risoe.BINfileData-class} object}

\item{show.record.number}{\link{logical} (with default): shows record number
of the imported record, for debugging usage only.}

\item{txtProgressBar}{\link{logical} (with default): enables or disables
\code{\link{txtProgressBar}}.}

\item{forced.VersionNumber}{\link{integer} (optional): allows to cheat the
version number check in the function by own values for cases where the
BIN-file version is not supported.\cr Note: The usage is at own risk, only
supported BIN-file versions have been tested.}
}
\value{
Returns an S4 \link{Risoe.BINfileData-class} object containing two
slots:\cr \item{METADATA}{A \link{data.frame} containing all variables
stored in the bin-file.} \item{DATA}{A \link{list} containing a numeric
\link{vector} of the measured data. The ID corresponds to the record ID in
METADATA.}\cr

If \code{fastForward = TRUE} a list of \code{\linkS4class{RLum.Analysis}} object is returned. The
internal coercing is done using the function \code{\link{Risoe.BINfileData2RLum.Analysis}}
}
\description{
Import a *.bin or a *.binx file produced by a Risoe DA15 and DA20 TL/OSL
reader into R.
}
\details{
The binary data file is parsed byte by byte following the data structure
published in the Appendices of the Analyst manual p. 42.\cr\cr For the
general BIN-file structure, the reader is referred to the Risoe website:
\code{http://www.nutech.dtu.dk/}
}
\note{
The function works for BIN/BINX-format versions 03, 04, 06 and 07. The
version number depends on the used Sequence Editor.\cr\cr \bold{Potential
other BIN/BINX-format versions are currently not supported. The
implementation of version 07 support could not been tested so far.}.
}
\section{Function version}{
 0.9.1 (2015-08-03 20:39:30)
}
\examples{
##(1) import Risoe BIN-file to R (uncomment for usage)

#FILE <- file.choose()
#temp <- readBIN2R(FILE)
#temp
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France), Margret C. Fuchs, TU Bergakademie Freiberg (Germany)
\cr R Luminescence Package Team}
\references{
Duller, G., 2007. Analyst.
\url{http://www.nutech.dtu.dk/english/~/media/Andre_Universitetsenheder/Nutech/Produkter\%20og\%20services/Dosimetri/radiation_measurement_instruments/tl_osl_reader/Manuals/analyst_manual_v3_22b.ashx}
}
\seealso{
\code{\link{writeR2BIN}}, \code{\linkS4class{Risoe.BINfileData}},
\code{\link[base]{readBin}}, \code{\link{merge_Risoe.BINfileData}}, \code{\linkS4class{RLum.Analysis}}
\code{\link[utils]{txtProgressBar}}
}
\keyword{IO}

