% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_RLum.Analysis.R
\name{merge_RLum.Analysis}
\alias{merge_RLum.Analysis}
\title{Merge function for RLum.Analysis S4 class objects}
\usage{
merge_RLum.Analysis(objects)
}
\arguments{
\item{objects}{\link{list} of \linkS4class{RLum.Analysis} (\strong{required}):
list of S4 objects of class \code{RLum.Analysis}. Furthermore other objects of
class \linkS4class{RLum} can be added, see details.}
}
\value{
Return an \linkS4class{RLum.Analysis} object.
}
\description{
Function allows merging of RLum.Analysis objects and adding of allowed
objects to an RLum.Analysis.
}
\details{
This function simply allowing to merge \linkS4class{RLum.Analysis}
objects.  Additionally other \linkS4class{RLum} objects can be added
to an existing \linkS4class{RLum.Analysis} object. Supported objects
to be added are: \linkS4class{RLum.Data.Curve},
\linkS4class{RLum.Data.Spectrum} and
\linkS4class{RLum.Data.Image}.

The order in the new \linkS4class{RLum.Analysis} object is the object
order provided with the input list.
}
\note{
The information for the slot 'protocol' is taken from the first
\linkS4class{RLum.Analysis} object in the input list. Therefore at
least one object of type \linkS4class{RLum.Analysis} has to be provided.
}
\section{Function version}{
 0.2.0
}

\examples{


##merge different RLum objects from the example data
data(ExampleData.RLum.Analysis, envir = environment())
data(ExampleData.BINfileData, envir = environment())

object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)
curve <- get_RLum(object)[[2]]

temp.merged <- merge_RLum.Analysis(list(curve, IRSAR.RF.Data, IRSAR.RF.Data))

}
\seealso{
\link{merge_RLum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Data.Image}, \linkS4class{RLum}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2021. merge_RLum.Analysis(): Merge function for RLum.Analysis S4 class objects. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.14. https://CRAN.R-project.org/package=Luminescence
}

\keyword{internal}
\keyword{utilities}
