% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_RLum2CSV.R
\name{write_RLum2CSV}
\alias{write_RLum2CSV}
\title{Export RLum-objects to CSV}
\usage{
write_RLum2CSV(
  object,
  path = NULL,
  prefix = "",
  export = TRUE,
  compact = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum} or a \link{list} of \code{RLum} objects (\strong{required}):
objects to be written}

\item{path}{\link{character} (\emph{optional}):
character string naming folder for the output to be written. If nothing
is provided \code{path} will be set to the working directory.
\strong{Note:} this argument is ignored if the the argument \code{export} is set to \code{FALSE}.}

\item{prefix}{\link{character} (\emph{with default}):
optional prefix to name the files. This prefix is valid for all written files}

\item{export}{\link{logical} (\emph{with default}):
enable or disable the file export. If set to \code{FALSE} nothing is written to
the file connection, but a list comprising objects of type \link{data.frame} and \link{matrix}
is returned instead}

\item{compact}{\link{logical} (\emph{with default}): if \code{TRUE} (the default) the output will be more
simple but less comprehensive, means not all elements in the objects will be fully broken down.
This is in particular useful for writing \code{RLum.Results} objects to CSV-files, such objects
can be rather complex and not all information are needed in a CSV-file or can be meaningful translated
to it.}

\item{...}{further arguments that will be passed to the function
\link[utils:write.table]{utils::write.table}. All arguments except the argument \code{file} are supported}
}
\value{
The function returns either a CSV-file (or many of them) or for the
option \code{export == FALSE} a list comprising objects of type \link{data.frame} and \link{matrix}
}
\description{
This function exports \linkS4class{RLum}-objects to CSV-files using the R function
\link[utils:write.table]{utils::write.table}. All \linkS4class{RLum}-objects are supported, but the
export is lossy, i.e. the pure numerical values are exported only. Information
that cannot be coerced to a \link{data.frame} or a \link{matrix} are discarded as well as
metadata.
}
\details{
However, in combination with the implemented import functions, nearly every
supported import data format can be exported to CSV-files, this gives a great
deal of freedom in terms of compatibility with other tools.

\strong{Input is a list of objects}

If the input is a \link{list} of objects all explicit function arguments can be provided
as \link{list}.
}
\section{Function version}{
 0.2.0
}

\examples{

##transform values to a list (and do not write)
data(ExampleData.BINfileData, envir = environment())
object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data)[[1]]
write_RLum2CSV(object, export = FALSE)

\dontrun{

##create temporary filepath
##(for usage replace by own path)
temp_file <- tempfile(pattern = "output", fileext = ".csv")

##write CSV-file to working directory
write_RLum2CSV(temp_file)

}

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data}, \linkS4class{RLum.Results},
\link[utils:write.table]{utils::write.table}
}
\author{
Sebastian Kreutzer, Geography & Earth Science, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2021. write_RLum2CSV(): Export RLum-objects to CSV. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.16. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
