% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_DetPlot.R
\name{plot_DetPlot}
\alias{plot_DetPlot}
\title{Create De(t) plot}
\usage{
plot_DetPlot(
  object,
  signal.integral.min,
  signal.integral.max,
  background.integral.min,
  background.integral.max,
  method = "shift",
  signal_integral.seq = NULL,
  analyse_function = "analyse_SAR.CWOSL",
  analyse_function.control = list(),
  n.channels = NULL,
  show_ShineDownCurve = TRUE,
  respect_RC.Status = FALSE,
  multicore = TRUE,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} (\strong{required}): input object containing data for analysis
Can be provided as a \link{list} of such objects.}

\item{signal.integral.min}{\link{integer} (\strong{required}):
lower bound of the signal integral.}

\item{signal.integral.max}{\link{integer} (\strong{required}):
upper bound of the signal integral. Must be strictly greater than
\code{signal.integral.min}.}

\item{background.integral.min}{\link{integer} (\strong{required}):
lower bound of the background integral.}

\item{background.integral.max}{\link{integer} (\strong{required}):
upper bound of the background integral.}

\item{method}{\link{character} (\emph{with default}):
method applied for constructing the De(t) plot.
\itemize{
\item \code{shift} (\emph{the default}): the chosen signal integral is shifted the shine down curve,
\item \code{expansion}: the chosen signal integral is expanded each time by its length
}}

\item{signal_integral.seq}{\link{numeric} (\emph{optional}):
argument to provide an own signal integral sequence for constructing the De(t) plot}

\item{analyse_function}{\link{character} (\emph{with default}):
name of the analyse function to be called. Supported functions are:
\link{analyse_SAR.CWOSL}, \link{analyse_pIRIRSequence}}

\item{analyse_function.control}{\link{list} (\emph{optional}):
selected arguments to be passed to the supported analyse functions
(\link{analyse_SAR.CWOSL}, \link{analyse_pIRIRSequence}). The arguments must be provided
as named \link{list}, e.g., \verb{list(dose.points = c(0,10,20,30,0,10)} will set the
regeneration dose points.}

\item{n.channels}{\link{integer} (\emph{optional}):
number of channels used for the De(t) plot. If nothing is provided all
De-values are calculated and plotted until the start of the background
integral.}

\item{show_ShineDownCurve}{\link{logical} (\emph{with default}):
enables or disables shine down curve in the plot output}

\item{respect_RC.Status}{\link{logical} (\emph{with default}):
remove De-values with 'FAILED' RC.Status from the plot
(cf. \link{analyse_SAR.CWOSL} and \link{analyse_pIRIRSequence})}

\item{multicore}{\link{logical} (\emph{with default}) : enables/disables multi core
calculation if \code{object} is a \link{list} of \linkS4class{RLum.Analysis} objects. Can be an
\link{integer} specifying the number of cores}

\item{verbose}{\link{logical} (\emph{with default}):
enables or disables terminal feedback}

\item{plot}{\link{logical} (\emph{with default}): enables/disables plot output
Disabling the plot is useful in cases where the output need to be processed
differently.}

\item{...}{further arguments and graphical parameters passed to
\link{plot.default}, \link{analyse_SAR.CWOSL} and \link{analyse_pIRIRSequence} (see details for further information).
Plot control parameters are: \code{ylim}, \code{xlim}, \code{ylab}, \code{xlab}, \code{main}, \code{pch}, \code{mtext}, \code{cex}, \code{legend},
\code{legend.text}, \code{legend.pos}}
}
\value{
A plot and an \linkS4class{RLum.Results} object with the produced \eqn{D_e} values

\verb{@data}:

\tabular{lll}{
\strong{Object} \tab \strong{Type} \tab \strong{Description}\cr
\code{De.values} \tab \code{data.frame} \tab table with De values \cr
\code{signal_integral.seq} \tab \code{numeric} \tab integral sequence used for the calculation
}

\verb{@info}:

\tabular{lll}{
\strong{Object} \tab \strong{Type} \tab \strong{Description}\cr
call \tab \code{call} \tab the original function call
}
}
\description{
Plots the equivalent dose (\eqn{D_e}) in dependency of the chosen signal integral
(cf. Bailey et al., 2003). The function is simply passing several arguments
to the function \link{plot} and the used analysis functions and runs it in a loop.
Example: \code{legend.pos} for legend position, \code{legend} for legend text.
}
\details{
\strong{method}

The original method presented by Bailey et al., 2003 shifted the signal integrals and slightly
extended them accounting for changes in the counting statistics. Example: \code{c(1:3, 3:5, 5:7)}.
However, here also another method is provided allowing to expand the signal integral by
consecutively expanding the integral by its chosen length. Example: \code{c(1:3, 1:5, 1:7)}

Note that in both cases the integral limits are overlap. The finally applied limits are part
of the function output.

\strong{analyse_function.control}

The argument \code{analyse_function.control} currently supports the following arguments
\code{sequence.structure}, \code{dose.points}, \code{mtext.outer}, \code{fit.method}, \code{fit.force_through_origin}, \code{plot}, \code{plot.single}
}
\note{
The entire analysis is based on the used analysis functions, namely
\link{analyse_SAR.CWOSL} and \link{analyse_pIRIRSequence}. However, the integrity
checks of this function are not that thoughtful as in these functions itself.
It means, that every sequence should be checked carefully before running long
calculations using several hundreds of channels.
}
\section{Function version}{
 0.1.7
}

\examples{

\dontrun{
##load data
##ExampleData.BINfileData contains two BINfileData objects
##CWOSL.SAR.Data and TL.SAR.Data
data(ExampleData.BINfileData, envir = environment())

##transform the values from the first position in a RLum.Analysis object
object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)

plot_DetPlot(
  object,
  signal.integral.min = 1,
  signal.integral.max = 3,
  background.integral.min = 900,
  background.integral.max = 1000,
  n.channels = 5)
}

} 

\section{How to cite}{
Kreutzer, S., 2024. plot_DetPlot(): Create De(t) plot. Function version 0.1.7. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.25. https://r-lum.github.io/Luminescence/
}

\references{
Bailey, R.M., Singarayer, J.S., Ward, S., Stokes, S., 2003. Identification of partial resetting
using De as a function of illumination time. Radiation Measurements 37, 511-518.
doi:10.1016/S1350-4487(03)00063-5
}
\seealso{
\link{plot}, \link{analyse_SAR.CWOSL}, \link{analyse_pIRIRSequence}
}
\author{
Sebastian Kreutzer, Institute of Geography, Ruprecht-Karl University of Heidelberg (Germany)
, RLum Developer Team}
