% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{PhyDataError}
\alias{PhyDataError}
\title{Phylogenetic Tree with Attached Bar Plot and Standard Error Bars}
\usage{
PhyDataError(phy, data, mcl_matrix, species_colname, data_colname,
  color = NULL, OG = NULL, xlabel = "xlabel", ...)
}
\arguments{
\item{phy}{Path to tree file}

\item{data}{R object of phenotype data}

\item{mcl_matrix}{AnalyzeOrthoMCL output}

\item{species_colname}{name of column in data file with taxa designations}

\item{data_colname}{name of column in data file with data observations}

\item{color}{optional parameter, (defaults to NULL) assign colors to individual taxa by providing file (format: Taxa | Color)}

\item{OG}{optional parameter, (defaults to NULL) a string with the names of chosen group to be colored}

\item{xlabel}{string to label barplot's x axis}

\item{...}{argument to be passed from other methods such as parameters from barplot() function}
}
\value{
A phylogenetic tree with a barplot of the data (with standard error bars) provided matched by taxa.
}
\description{
Presents data for each taxa including standard error bars next to a phylogenetic tree.
}
\examples{

file <- system.file('extdata', 'muscle_tree2.dnd', package='MAGNAMWAR')
PhyDataError(file, pheno_data, mcl_mtrx, species_colname = 'Treatment', data_colname = 'RespVar',
 OG='OG5_126778', xlabel='TAG Content')

}
\references{
Some sort of reference
}
