% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JoinRepSeq.R
\name{JoinRepSeq}
\alias{JoinRepSeq}
\title{Join Representative Sequences}
\usage{
JoinRepSeq(mcl_data, fa_dir, mcl_mtrx, fastaformat = "new")
}
\arguments{
\item{mcl_data}{output of FormatAfterOrtho; a list of matrices; (1) a presence/absence matrix of taxa per OG, (2) a list of the specific protein ids within each OG}

\item{fa_dir}{Path to the directory where all raw GenBank files are stored. Note, all file names must be changed to a 4-letter code representing each species and have '.fasta' file descriptor}

\item{mcl_mtrx}{OrthoMCL output matrix from AnalyzeOrthoMCL()}

\item{fastaformat}{options: new & old; new = no GI numbers included; defaults to new}
}
\value{
Returns the original OrthoMCL output matrix with additional columns: representative sequence taxon, representative sequence id, representative sequence annotation, representative sequence
}
\description{
Joins the OrthoMCL output matrix to representative sequences
}
\examples{

dir <- system.file('extdata', 'fasta_dir', package='MAGNAMWAR')
dir <- paste(dir,'/',sep='')
joined_mtrx_grps <- JoinRepSeq(after_ortho_format_grps, dir, mcl_mtrx_grps, fastaformat = 'old')

}
