% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_04_PREPROCESS_4_TransformGeneValues.R
\name{TransformExpValues}
\alias{TransformExpValues}
\title{Transform gene expression Values}
\usage{
TransformExpValues(
  MarvelObject,
  offset = 1,
  transformation = "log2",
  threshold.lower = 1
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment} function.}

\item{offset}{Numeric value. To indicate the value to add to the expression values before log transformation. The only option for this argument is 1.}

\item{transformation}{Character string. To indicate the type of transformation to use on the expression values after offsetting the values. The only option for this argument is \code{log2}.}

\item{threshold.lower}{Numeric value. To indicate the value below which the expression values will be censored, i.e. re-coded as 0, after offsetting and transforming the values. The only option for this argument is \code{1}.}
}
\value{
An object of class S3 with updated slot \code{MarvelObject$Exp}.
}
\description{
Transforms gene expression values and censor lowly-expressing genes.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- TransformExpValues(MarvelObject=marvel.demo,
                                  offset=1,
                                  transformation="log2",
                                  threshold.lower=1
                                  )
}
