% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeuralNetworkModel.r
\name{NeuralNetworkModel}
\alias{NeuralNetworkModel}
\title{Artificial neural network model}
\arguments{
\item{Epochs}{The number of epochs.}

\item{NewData}{A methylation data from ReadMethylFile function.}

\item{InstallTensorFlow}{Logical. Running this function for the first time, you need to install TensorFlow library (V 2.10-cpu). Default is TRUE.}
}
\value{
A list
}
\description{
A function to train an artificial neural network model to classify medulloblastoma subgroups using the DNA methylation dataset (Illumina Infinium HumanMethylation450). Prediction is followed by training if new data is provided.
}
\examples{
\dontrun{
set.seed(1234)
ann <- NeuralNetworkModel(Epochs = 100,
                          NewData = NULL,
                          InstallTensorFlow = TRUE)
}
}
