% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{getjagsdata}
\alias{getjagsdata}
\title{Prepares data for JAGS}
\usage{
getjagsdata(data.ab, class = FALSE, rho = NULL, covstruct = "CS")
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{time} Numeric data indicating follow-up times
\item \code{y} Numeric data indicating the aggregate response for a given observation (e.g. mean)
\item \code{se} Numeric data indicating the standard error for a given observation
\item \code{treatment} Treatment identifiers (can be numeric, factor or character)
\item \code{class} An optional column indicating a particular class identifier. Observations with the same treatment
identifier must also have the same class identifier.
\item \code{N} An optional column indicating the number of participants used to calculate the
response at a given observation
}}

\item{class}{A boolean object indicating whether or not \code{data.ab} contains
information on different classes of treatments}

\item{rho}{The correlation coefficient when modelling correlation between time points. If left
as \code{NULL} (the default) then this implies modelling no correlation between time points.
Can either be assigned the string \code{"estimate"} to indicate that rho should be estimated
from the data, or assigned a numeric value, which fixes \code{rho} in the model to the assigned
value, either for when \code{rho} is calculated externally or for use in deterministic sensitivity
analyses.}

\item{covstruct}{A character to indicate the covariance structure required for modelling correlation between
time points (if any), since
this determines some of the data. Can be either \code{"CS"} (compound symmetry) or \code{"AR1"} (autoregressive AR1).}
}
\value{
A named list of numbers, vector, matrices and arrays to be sent to
JAGS. List elements are:
\itemize{
\item \code{y} An array of mean responses for each observation in each arm within each study
\item \code{se} An array of standard errors for each observation in each arm within each study
\item \code{time} A matrix of follow-up times within each study
\item \code{fups} A numeric vector with the number of follow-up measurements per study
\item \code{narm} A numeric vector with the number of arms per study
\item \code{NS} The total number of studies in the dataset
\item \code{NT} The total number of treatments in the dataset
\item \code{treat} A matrix of treatment codes within each study
\item \code{Nclass} Optional. The total number of classes in the dataset
\item \code{class} Optional. A matrix of class codes within each study
\item \code{classkey} Optional. A vector of class codes that correspond to treatment codes.
Same length as the number of treatment codes.
\item \code{mat.triangle} Optional. A matrix with number indicating how to fill covariance
matrices within the JAGS code.
\item \code{mat.order} Optional. A matrix with number indicating what order to fill
covariance matrices within the JAGS code.
\item \code{timedif.0} Optional. A vector of the difference in times between the first and second
follow-up time in each study.
}
}
\description{
Converts MBNMA data frame to a list for use in JAGS model
}
\examples{
# Using the alogliptin dataset
network <- mb.network(alog_pcfb)
jagsdat <- getjagsdata(network$data.ab)


# Get JAGS data with class
netclass <- mb.network(goutSUA_CFBcomb)
jagsdat <- getjagsdata(netclass$data.ab, class=TRUE)


# Get JAGS data that allows for modelling correlation between time points
painnet <- mb.network(osteopain)
jagsdat <- getjagsdata(painnet$data.ab, rho="estimate", covstruct="AR1")

}
