% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{write.ref.synth}
\alias{write.ref.synth}
\title{Write MBNMA time-course models JAGS code for synthesis of studies
investigating reference treatment}
\usage{
write.ref.synth(
  fun = tpoly(degree = 1),
  link = "identity",
  positive.scale = TRUE,
  intercept = TRUE,
  rho = 0,
  covar = "varadj",
  mu.synth = "random",
  priors = NULL
)
}
\arguments{
\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{titp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}

\item{link}{Can take either \code{"identity"} (the default),
\code{"log"} (for modelling Ratios of Means \insertCite{friedrich2011}{MBNMAtime}) or
\code{"smd"} (for modelling Standardised Mean Differences - although this also corresponds to an identity link function).}

\item{positive.scale}{A boolean object that indicates whether all continuous
mean responses (y) are positive and therefore whether the baseline response
should be given a prior that constrains it to be positive (e.g. for scales that cannot be <0).}

\item{intercept}{A boolean object that indicates whether an intercept (written
as \code{alpha} in the model) is to be included. If left as \code{NULL} (the default), an intercept will
be included only for studies reporting absolute means, and will be excluded for
studies reporting change from baseline (as indicated in \code{network$cfb}).}

\item{rho}{The correlation coefficient when modelling within-study correlation between time points. The default is a string representing a
prior distribution in JAGS, indicating that it be estimated from the data (e.g. \code{rho="dunif(0,1)"}). \code{rho} also be assigned a
numeric value (e.g. \code{rho=0.7}), which fixes \code{rho} in the model to this value (e.g. for use in a deterministic sensitivity analysis).
If set to \code{rho=0} (the default) then this implies modelling no correlation between time points.}

\item{covar}{A character specifying the covariance structure to use for modelling within-study correlation between time-points. This can
be done by specifying one of the following:
\itemize{
\item \code{"varadj"} - a univariate likelihood with a variance adjustment to assume a constant correlation between subsequent
time points \insertCite{jansen2015}{MBNMAtime}. This is the default.
\item \code{"CS"} - a multivariate normal likelihood with a
\href{https://support.sas.com/resources/papers/proceedings/proceedings/sugi30/198-30.pdf}{compound symmetry} structure
\item \code{"AR1"} - a multivariate normal likelihood with an
\href{https://support.sas.com/resources/papers/proceedings/proceedings/sugi30/198-30.pdf}{autoregressive AR1} structure
}}

\item{mu.synth}{A string that takes the value \code{fixed} or \code{random}, indicating
the type of synthesis model to use}

\item{priors}{A named list of parameter values (without indices) and
replacement prior distribution values given as strings
\strong{using distributions as specified in JAGS syntax} (see \insertCite{jagsmanual;textual}{MBNMAtime}).}
}
\value{
A character object of JAGS MBNMA model code that includes beta
parameter components of the model
}
\description{
Writes JAGS code for a Bayesian time-course model for model-based network
meta-analysis (MBNMA) that pools reference treatment effects from different
studies. This model only pools single study arms and therefore does not pool
relative effects.
}
\examples{
# Write a log-linear time-course MBNMA synthesis model with:
# Common effects for synthesis of mu
# Modelled as ratio of means
model <- write.ref.synth(fun=tloglin(pool.rate="rel", method.rate="common"),
  mu.synth="common", link="log")

cat(model) # Concatenates model representations making code more easily readable

}
