% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet_mle.R
\name{fit_dirichlet}
\alias{fit_dirichlet}
\title{Estimate Parameters of Dirichlet Distribution}
\usage{
fit_dirichlet(x, const, maxit = 1e+05, abstol = 0.1)
}
\arguments{
\item{x}{a matrix of Dirichlet samples, one row per observation.}

\item{const}{constant that is added to avoid problems with zeros in \code{log(x)}.
The default is \code{const = min(x[x>0])*.01}.}

\item{maxit}{maximum number of iterations.}

\item{abstol}{The absolute convergence tolerance: maximum of absolute differences of Dirichlet parameters.}
}
\description{
C++ implementation of the fixed-point iteration algorithm by Minka (2000).
}
\details{
The algorithm is used to estimate the effective sample size based on samples
   of posterior model probabilities (see \code{\link{stationary}} and
   \code{\link{summary.stationary}}).
}
\examples{
x <- rdirichlet(100, c(8,1,3,9))
fit_dirichlet(x)

}
\references{
Minka, T. (2000). Estimating a Dirichlet distribution. Technical Report.
}
\seealso{
\code{\link{rdirichlet}}
}
