% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourier_basis_expansion.R
\name{fourier_basis_expansion}
\alias{fourier_basis_expansion}
\alias{fourier_basis_expansion,functional_variable,integer-method}
\title{Fourier basis expansion for functional variable data}
\usage{
fourier_basis_expansion(object, order_fourier_basis)

\S4method{fourier_basis_expansion}{functional_variable,integer}(object, order_fourier_basis)
}
\arguments{
\item{object}{a \code{\link{functional_variable}} class object.}

\item{order_fourier_basis}{the order of Fourier basis, \eqn{p_f}.}
}
\value{
Returns a numeric matrix, \eqn{(b_{ik})_{n\times p}}, where \eqn{b_{ik} = \int_\Omega f(t)\rho_k(t) dt}
}
\description{
For a function \eqn{f(x), x\in\Omega}, and a basis function sequence \eqn{\{\rho_k\}_{k\in\kappa}},
basis expansion is to compute \eqn{\int_\Omega f(t)\rho_k(t) dt}.
Here we do basis expansion for all \eqn{f_i(t), t\in\Omega = [t_0,t_0+T]} in functional variable data, \eqn{i=1,\dots,n}.
We compute a matrix \eqn{(b_{ik})_{n\times p}}, where \eqn{b_{ik} = \int_\Omega f(t)\rho_k(t) dt}.
The basis used here is the Fourier basis, \deqn{\frac{1}{2},\ \cos(\frac{2\pi}{T}k[x-t_0]),\ \sin (\frac{2\pi}{T}k[x-t_0])}
where \eqn{x\in[t_0,t_0+T]} and \eqn{k = 1,\dots,p_f}.
}
\author{
Heyang Ji
}
