% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CISIS.R
\name{CISIS}
\alias{CISIS}
\title{Model-Free Feature screening Based on Concordance Index for Ultra-High Dimensional Categorical Data}
\usage{
CISIS(X, Y, nsis)
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by CISIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
The proposed method is based on the concordance index which measures concordance between random vectors.
A model-free and robust feature screening method for ultrahigh-dimensional categorical data.
The performance is quite robust in the presence of heavy-tailed distributions, extremely unbalance responses, and category-adaptive data.
}
\examples{

n <- 100
p <- 200
rho <- 0.5
data <- GendataLGM(n, p, rho)
data <- cbind(data[[1]], data[[2]])
colnames(data)[1:ncol(data)] <- c(paste0("X", 1:(ncol(data) - 1)), "Y")
data <- as.matrix(data)
X <- data[, 1:(ncol(data) - 1)]
Y <- data[, ncol(data)]
A <- CISIS(X, Y, n / log(n))
A

}
\references{
Cheng X, Wang H. A generic model-free feature screening procedure for ultra-high dimensional data with categorical response[J]. Computer Methods and Programs in Biomedicine, 2023, 229: 107269.
}
\author{
Xuewei Cheng \email{xwcheng@hunnu.edu.cn}
}
