% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcGammaKernel}
\alias{calcGammaKernel}
\title{Calculate Gamma Stochastic Matrix}
\usage{
calcGammaKernel(distMat, shape, rate)
}
\arguments{
\item{distMat}{distance matrix from \code{\link[MGDrivE]{calcVinEll}}}

\item{shape}{shape parameter of \code{\link[stats]{GammaDist}} distribution}

\item{rate}{rate parameter of \code{\link[stats]{GammaDist}} distribution}
}
\description{
Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}}, calculate a
stochastic matrix where one step movement probabilities follow a gamma density.
}
\examples{
# setup distance matrix
# two-column matrix with latitude/longitude, in degrees
latLong = cbind(runif(n = 5, min = 0, max = 90),
                runif(n = 5, min = 0, max = 180))

# Vincenty Ellipsoid  distance formula
distMat = calcVinEll(latLongs = latLong)

# calculate gamma distribution over distances
#  shape and rate are just for example
kernMat = calcGammaKernel(distMat = distMat, shape = 1, rate = 1)

}
