% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Graphics.R
\name{plotMGDrivESingle}
\alias{plotMGDrivESingle}
\title{Plot}
\usage{
plotMGDrivESingle(readDir, whichPatches = NULL, totalPop = FALSE,
                         nonZeroGen = FALSE, lwd = 0.75, alpha = 0.75)
}
\arguments{
\item{readDir}{Path to file from single-run of MGDrivE or from analysis function}

\item{whichPatches}{Vector of patches to plot, must be less than 15. Default is NULL if less than 15 patches}

\item{totalPop}{Boolean, to plot the total population or not.}

\item{nonZeroGen}{Boolean, to plot genotypes that are always zero in simulation}

\item{lwd}{Double, specify the line width for plotting}

\item{alpha}{Double, specify the opacity for plotting}
}
\description{
Plots one run from MGDrivE
}
\details{
This function plots output from one run or one set of runs after being analyzed. Setting totalPop
to FALSE keeps it from plotting the total population. NonZeroGen accounts for
genotypes that could exist, but are not created in the simulation. Default
is FALSE, as this is easier to read on a plot.
}
\examples{
\dontrun{
# Requires the user to have run MGDrivE, deterministic or stochastic, analyzed
#  the data, and stored it in the directory shown below.
# See vignette for complete example

# Folder where single run is stored
fPath <- "path/to/data/containing/folder"

# plot output to see effect
plotMGDrivESingle(readDir=fPath,totalPop = TRUE,lwd=3.5,alpha=1)
}


}
