% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilson.R
\name{Tm}
\alias{Tm}
\title{Estimate variance of proportion point estimate \eqn{\bar{Q}_m}}
\usage{
Tm(qhats, m, nrow)
}
\arguments{
\item{qhats}{vector of Qhats(means of response for each imputed dataset)}

\item{m}{number of imputed datasets}

\item{nrow}{number of observations in the imputed dataset}
}
\value{
variance of proportion point estimate
}
\description{
Estimate variance of proportion point estimate \eqn{\bar{Q}_m}
}
\examples{
imp = mice::mice(mice::nhanes)
qhats = Qhats(imp, "hyp")
m = imp$m
nrow = imp$data \%>\% nrow()
Tm(qhats, m, nrow)

}
