% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEce.R
\name{confCI}
\alias{confCI}
\title{Getting confidence intervals for efficient closed-form estimators}
\usage{
confCI(object, bootsize = 1000, level = 0.95)
}
\arguments{
\item{object}{an object of class \code{"MLEce"} made by the function \code{MLEce}.}

\item{bootsize}{a numeric value for the steps in the bootstrap method; default value is 1,000.}

\item{level}{a numeric value between 0 and 1 for controlling the significance level of confidence interval; default value is 0.95.}
}
\value{
a numeric a list is given, containing assigned distribution, confidence intervals and alpha which is equal to one minus the significance level.
}
\description{
Getting confidence intervals for efficient closed-form estimators
}
\details{
The confidence interval is obtained by bootstrap method for the estimated parameters in the assigned distribution.
}
\examples{
data(flood)
est_BiGam <- MLEce(flood, "BiGam")
confCI(est_BiGam)
datt = rBiWei(n=50, c(4,3,3,4,0.6))
est_BiWei <-MLEce(datt, "BiWei")
confCI(est_BiWei)
data_Diri <- LaplacesDemon::rdirichlet(n=60, c(3,1,2,4))
est_Diri <- MLEce(data_Diri, "Dirichlet")
confCI(est_Diri)
}
