% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{residstd}
\alias{residstd}
\title{Classification of cases as typical and deviant using the standard
deviation of the residuals.}
\usage{
residstd(lmobject, stdshare = 1)
}
\arguments{
\item{lmobject}{Object generated with \code{\link[stats]{lm}}}

\item{stdshare}{Share of standard deviation of residuals distinguishing
between typical and deviant cases (default is 1).}
}
\value{
A dataframe with the observed outcome, fitted outcome,
residual standard deviation and classification of cases as typical
or deviant.
}
\description{
The share of the standard deviation of the residuals is used to
designate cases as typical or deviant.
}
\details{
Proposed by Lieberman, Evan S. (2005): Nested Analysis as a Mixed-Method
Strategy for Comparative Research. \emph{American Political Science Review}
99 (3): 435-452. \url{https://doi.org/10.1017/S0003055405051762}.
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
residstd(df, stdshare = 1)

}
