% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionalityReduction.R
\name{bulkDimReduction}
\alias{bulkDimReduction}
\title{\code{bulkDimReduction}}
\usage{
bulkDimReduction(
  SampleTileObj,
  cellType = "All",
  componentNumber = 30,
  method = "LSI",
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObj}{The SummarizedExperiment object output from getSampleTileMatrix}

\item{cellType}{vector of strings. Cell subsets for which to call
peaks. This list of group names must be identical to names that appear in
the SampleTileObj.  Optional, if cellPopulations='ALL', then peak
calling is done on all cell populations. Default is 'ALL'.}

\item{componentNumber}{integer. Number of components to include in LSI, or PCA This must be strictly less than}

\item{method}{a string. Represents the method to use. Includes LSI or PCA, but we do not recommend PCA for scATAC pseudobulk.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
SEObj a SummarizedExperiment containing PC components from dimensionality reduction and metadata from the SampleTileObj
}
\description{
\code{bulkDimReduction} runs dimensionality reduction (either PCA or LSI). We adapt Signac's
}
\examples{
\dontrun{
LSIObj <- MOCHA::bulkDimReduction(SampleTileObj, cellType = "CD16_Mono")
}
}
\references{
LSI method adapted from Andrew Hill: http://andrewjohnhill.com/blog/2019/05/06/dimensionality-reduction-for-scatac-data/
}
