% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_none.R
\name{constraint_none}
\alias{constraint_none}
\title{NULL constraint handling method for MOEA/D}
\usage{
constraint_none(B, bigZ, bigV, ...)
}
\arguments{
\item{B}{Matrix of neighborhoods (generated by \code{define_neighborhood(...))})}

\item{bigZ}{Matrix of scalarized objective values for each neighborhood and the
incumbent solution (generated by \code{scalarize_values})}

\item{bigV}{Matrix of violation values for each neighborhood and the
incumbent solution}

\item{...}{other parameters (unused, included for compatibility with
generic call)}
}
\value{
\code{[ N x (T+1) ]} matrix of preference indices. Each row \code{i} contains
a permutation of \code{{1, 2, ..., (T+1)}}, where \code{1,...,T} correspond
to the solutions contained in the neighborhood of the i-th subproblem,
\code{B[i, ]}, and \code{T+1} corresponds to the incumbent solution for that
subproblem. The order of the permutation is defined by the increasing values
of \code{f(xk)}, where \code{f(xk)} is the aggregation function value of
the k-th solution being compared.
}
\description{
Construct the preference index matrix based only on performance values.
}
\details{
This function ignores the violation values when constructing the preference
index matrix, using only the scalarized performance values.
}
