% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updt_standard.R
\name{updt_standard}
\alias{updt_standard}
\title{Standard Neighborhood Replacement Update for MOEA/D}
\usage{
updt_standard(X, Xt, Y, Yt, V, Vt, sel.indx, B, ...)
}
\arguments{
\item{X}{Matrix of candidate solutions}

\item{Xt}{Matrix of incumbent solutions}

\item{Y}{Matrix of objective function values of \code{X}}

\item{Yt}{Matrix of objective function values of \code{Xt}}

\item{V}{List object containing information about the constraint violations
of the candidate solutions, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{Vt}{List object containing information about the constraint violations
of the incumbent solutions, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{sel.indx}{matrix of selection indices, generated by
\code{\link[=order_neighborhood]{order_neighborhood()}}}

\item{B}{Neighborhood matrix, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
List object containing the update population matrix (\code{X}),
and its corresponding matrix of objective function values (\code{Y}) and
constraint value list (\code{V}).
}
\description{
Population update using the standard neighborhood replacement method for the
MOEADr package.
}
\details{
This routine executes the standard neighborhood replacement operation to
update the population matrix of the MOEA/D.
This update routine is intended to be used internally by the main \code{\link[=moead]{moead()}}
function, and should not be called directly by the user.
}
\section{References}{


F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

