% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{summspm}
\alias{summspm}
\title{summspm extracts critical statistics from output of plotspmmod}
\usage{
summspm(ans)
}
\arguments{
\item{ans}{the object output from the function plotspmmod used to plot
the output of a surplus production analysis}
}
\value{
a matrix of statistics relating to MSY, expected yields, and
    depletion levels
}
\description{
summspm extracts critical statistics from output of 
    plotspmmod. In particular it pulls out the catchability q, the MSY, 
    Bmsy, Dmsy, Blim, Btarg, Ctarg. and Dcurr.
}
\examples{
data(dataspm)
plotfishM(dataspm,spsname="Pink Ling")
pars <- log(c(0.264,4740,3064,0.05))
ans <- plotspmmod(pars,dataspm,schaefer=FALSE,plotout=FALSE)
bestSP <- fitSPM(pars,dataspm,schaefer=FALSE,maxiter=1000)
outfit(bestSP)
ans <- plotspmmod(bestSP$estimate,dataspm,schaefer=FALSE,plotout=FALSE)
summspm(ans)
}
